/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.client;

import io.netty.buffer.DrillBuf;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.common.DrillAutoCloseables;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.client.QuerySubmitter;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.rpc.ConnectionThrottle;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.apache.drill.exec.util.VectorUtil;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingResultsListener
implements UserResultsListener {
    private static Logger logger = LoggerFactory.getLogger(LoggingResultsListener.class);
    private final AtomicInteger count = new AtomicInteger();
    private final Stopwatch w = Stopwatch.createUnstarted();
    private final RecordBatchLoader loader;
    private final QuerySubmitter.Format format;
    private final int columnWidth;
    private final BufferAllocator allocator;

    public LoggingResultsListener(DrillConfig config, QuerySubmitter.Format format, int columnWidth) {
        this.allocator = RootAllocatorFactory.newRoot(config);
        this.loader = new RecordBatchLoader(this.allocator);
        this.format = format;
        this.columnWidth = columnWidth;
    }

    @Override
    public void submissionFailed(UserException ex) {
        logger.info("Exception (no rows returned). Returned in {} ms.", (Object)this.w.elapsed(TimeUnit.MILLISECONDS), (Object)ex);
    }

    @Override
    public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
        DrillAutoCloseables.closeNoChecked(this.allocator);
        logger.info("Total rows returned: {}. Returned in {} ms.", (Object)this.count.get(), (Object)this.w.elapsed(TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
        UserBitShared.QueryData header = result.getHeader();
        DrillBuf data = result.getData();
        try {
            if (data == null) return;
            this.count.addAndGet(header.getRowCount());
            this.loader.load(header.getDef(), data);
            try {
                switch (this.format) {
                    case TABLE: {
                        VectorUtil.logVectorAccessibleContent((VectorAccessible)this.loader, this.columnWidth);
                        return;
                    }
                    case TSV: {
                        VectorUtil.logVectorAccessibleContent((VectorAccessible)this.loader, "\t");
                        return;
                    }
                    case CSV: {
                        VectorUtil.logVectorAccessibleContent((VectorAccessible)this.loader, ",");
                        return;
                    }
                    default: {
                        throw new IllegalStateException(this.format.toString());
                    }
                }
            }
            finally {
                this.loader.clear();
            }
        }
        finally {
            result.release();
        }
    }

    @Override
    public void queryIdArrived(UserBitShared.QueryId queryId) {
        this.w.start();
    }
}

