/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.io.IOException;
import java.util.Map;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.compile.ClassTransformer;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;

public abstract class AbstractClassCompiler {
    protected boolean debug = false;

    AbstractClassCompiler(boolean debug) {
        this.debug = debug;
    }

    public byte[][] getClassByteCode(ClassTransformer.ClassNames className, String sourceCode) throws CompileException, IOException, ClassNotFoundException, ClassTransformationException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Compiling (source size={}):\n{}", (Object)DrillStringUtils.readable(sourceCode.length()), (Object)this.prefixLineNumbers(sourceCode));
        }
        return this.getByteCode(className, sourceCode);
    }

    protected String prefixLineNumbers(String code) {
        if (!this.debug) {
            return code;
        }
        StringBuilder out = new StringBuilder();
        int i = 1;
        for (String line : code.split("\n")) {
            int start = out.length();
            out.append(i++);
            int numLength = out.length() - start;
            out.append(":");
            for (int spaces = 0; spaces < 7 - numLength; ++spaces) {
                out.append(" ");
            }
            out.append(line);
            out.append('\n');
        }
        return out.toString();
    }

    protected abstract byte[][] getByteCode(ClassTransformer.ClassNames var1, String var2) throws CompileException, IOException, ClassNotFoundException, ClassTransformationException;

    public abstract Map<String, byte[]> compile(ClassTransformer.ClassNames var1, String var2) throws CompileException, IOException, ClassNotFoundException;

    protected abstract Logger getLogger();
}

