/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.drill.exec.compile.DrillCheckClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.TraceClassVisitor;
import org.slf4j.Logger;

public class AsmUtil {
    private AsmUtil() {
    }

    public static boolean isClassOk(Logger logger, String logTag, ClassNode classNode) {
        StringWriter sw = new StringWriter();
        ClassWriter verifyWriter = new ClassWriter(2);
        classNode.accept((ClassVisitor)verifyWriter);
        ClassReader ver = new ClassReader(verifyWriter.toByteArray());
        try {
            DrillCheckClassAdapter.verify(ver, false, new PrintWriter(sw));
        }
        catch (Exception e) {
            logger.info("Caught exception verifying class:");
            AsmUtil.logClass(logger, logTag, classNode);
            throw e;
        }
        String output = sw.toString();
        if (!output.isEmpty()) {
            logger.info("Invalid class:\n" + output);
            return false;
        }
        return true;
    }

    public static boolean isClassBytesOk(Logger logger, String logTag, byte[] classBytes) {
        ClassNode classNode = AsmUtil.classFromBytes(classBytes, 0);
        return AsmUtil.isClassOk(logger, logTag, classNode);
    }

    public static ClassNode classFromBytes(byte[] classBytes, int asmReaderFlags) {
        ClassNode classNode = new ClassNode(589824);
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept((ClassVisitor)classNode, asmReaderFlags);
        return classNode;
    }

    public static void logClass(Logger logger, String logTag, ClassNode classNode) {
        if (logger.isTraceEnabled()) {
            logger.trace(logTag);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            TraceClassVisitor traceClassVisitor = new TraceClassVisitor(printWriter);
            classNode.accept((ClassVisitor)traceClassVisitor);
            logger.trace(stringWriter.toString());
        }
    }

    public static void logClassFromBytes(Logger logger, String logTag, byte[] classBytes) {
        ClassNode classNode = AsmUtil.classFromBytes(classBytes, 0);
        AsmUtil.logClass(logger, logTag, classNode);
    }

    public static boolean isXconst(int opcode) {
        switch (opcode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public static boolean isXadd(int opcode) {
        switch (opcode) {
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                return true;
            }
        }
        return false;
    }
}

