/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class CachedClassLoader
extends URLClassLoader {
    private ConcurrentMap<String, Class<?>> cache = Maps.newConcurrentMap();

    public CachedClassLoader() {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
    }

    public void addClass(String fqcn, byte[] byteCodes) {
        Class<?> newClass = this.defineClass(fqcn, byteCodes, 0, byteCodes.length);
        this.cache.put(fqcn, newClass);
    }

    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        Class theClass = (Class)this.cache.get(className);
        if (theClass != null) {
            return theClass;
        }
        return super.findClass(className);
    }

    public void addClasses(Map<String, byte[]> results) {
        for (Map.Entry<String, byte[]> result : results.entrySet()) {
            this.addClass(result.getKey(), result.getValue());
        }
    }
}

