/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.codehaus.commons.compiler.CompileException;

public class ClassBodyBuilder {
    private String[] optionalDefaultImports = null;
    private String className = "SC";
    private Class<?> optionalExtendedType = null;
    private Class<?>[] implementedTypes = new Class[0];
    private String[] imports = new String[0];
    private String body;
    private boolean used = false;

    public static ClassBodyBuilder newBuilder() {
        return new ClassBodyBuilder();
    }

    private ClassBodyBuilder() {
    }

    public ClassBodyBuilder setClassName(String className) {
        this.assertNotCooked();
        this.className = className;
        return this;
    }

    public ClassBodyBuilder setDefaultImports(String ... optionalDefaultImports) {
        this.assertNotCooked();
        this.optionalDefaultImports = optionalDefaultImports;
        return this;
    }

    public ClassBodyBuilder setExtendedClass(Class<?> optionalExtendedType) {
        this.assertNotCooked();
        this.optionalExtendedType = optionalExtendedType;
        return this;
    }

    public ClassBodyBuilder setImplementedInterfaces(Class<?> ... implementedTypes) {
        this.assertNotCooked();
        this.implementedTypes = implementedTypes;
        return this;
    }

    private void assertNotCooked() {
        assert (!this.used);
    }

    public ClassBodyBuilder setImports(String[] imports) {
        this.assertNotCooked();
        this.imports = imports;
        return this;
    }

    public ClassBodyBuilder setBody(String body) {
        this.assertNotCooked();
        this.body = body;
        return this;
    }

    public String build() throws CompileException, IOException {
        String simpleClassName;
        String packageName;
        this.used = true;
        StringWriter sw1 = new StringWriter();
        PrintWriter pw = new PrintWriter(sw1);
        int idx = this.className.lastIndexOf(46);
        if (idx == -1) {
            packageName = "";
            simpleClassName = this.className;
        } else {
            packageName = this.className.substring(0, idx);
            simpleClassName = this.className.substring(idx + 1);
        }
        if (!packageName.isEmpty()) {
            pw.print("package ");
            pw.print(packageName);
            pw.println(";");
        }
        if (this.optionalDefaultImports != null) {
            for (String defaultImport : this.optionalDefaultImports) {
                pw.print("import ");
                pw.print(defaultImport);
                pw.println(";");
            }
        }
        for (String imporT : this.imports) {
            pw.print("import ");
            pw.print(imporT);
            pw.println(";");
        }
        pw.print("public class ");
        pw.print(simpleClassName);
        if (this.optionalExtendedType != null) {
            pw.print(" extends ");
            pw.print(this.optionalExtendedType.getCanonicalName());
        }
        if (this.implementedTypes.length > 0) {
            pw.print(" implements ");
            pw.print(this.implementedTypes[0].getName());
            for (int i = 1; i < this.implementedTypes.length; ++i) {
                pw.print(", ");
                pw.print(this.implementedTypes[i].getName());
            }
        }
        pw.println(" {");
        pw.close();
        StringWriter sw2 = new StringWriter();
        PrintWriter pw2 = new PrintWriter(sw2);
        pw2.println("}");
        pw2.close();
        return sw1.toString() + this.body + sw2.toString();
    }
}

