/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.compile.ClassBuilder;
import org.apache.drill.exec.compile.ClassTransformer;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheBuilder;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheLoader;
import org.apache.drill.shaded.guava.com.google.common.cache.LoadingCache;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeCompiler {
    private static final Logger logger = LoggerFactory.getLogger(CodeCompiler.class);
    public static final String COMPILE_BASE = "drill.exec.compile";
    public static final String MAX_LOADING_CACHE_SIZE_CONFIG = "drill.exec.compile.cache_max_size";
    public static final String DISABLE_CACHE_CONFIG = "drill.exec.compile.disable_cache";
    public static final String ENABLE_SAVE_CODE_FOR_DEBUG_TOPN = "drill.exec.compile.codegen.debug.topn";
    public static final String PREFER_POJ_CONFIG = "drill.exec.compile.prefer_plain_java";
    private final CodeGenCompiler codeGenCompiler;
    private final boolean useCache;
    private int classGenCount;
    private int cacheMissCount;
    private final LoadingCache<CodeGenerator<?>, GeneratedClassEntry> cache;
    private final boolean preferPlainJava;

    public CodeCompiler(DrillConfig config, OptionSet optionManager) {
        this.codeGenCompiler = new CodeGenCompiler(config, optionManager);
        this.useCache = !config.getBoolean(DISABLE_CACHE_CONFIG);
        this.cache = CacheBuilder.newBuilder().maximumSize(config.getInt(MAX_LOADING_CACHE_SIZE_CONFIG)).build(new Loader());
        this.preferPlainJava = config.getBoolean(PREFER_POJ_CONFIG);
        logger.info(String.format("Plain java code generation preferred: %b", this.preferPlainJava));
    }

    public <T> T createInstance(CodeGenerator<?> cg) throws ClassTransformationException {
        return this.createInstances(cg, 1).get(0);
    }

    public <T> List<T> createInstances(CodeGenerator<?> cg, int count) throws ClassTransformationException {
        if (this.preferPlainJava && cg.supportsPlainJava()) {
            cg.preferPlainJava(true);
        }
        cg.generate();
        ++this.classGenCount;
        try {
            GeneratedClassEntry ce;
            if (this.useCache) {
                ce = this.cache.get(cg);
                logger.trace(String.format("Class %s found in code cache", cg.getClassName()));
            } else {
                ce = this.makeClass(cg);
            }
            ArrayList tList = Lists.newArrayList();
            for (int i = 0; i < count; ++i) {
                tList.add(ce.clazz.newInstance());
            }
            return tList;
        }
        catch (Exception e) {
            throw new ClassTransformationException(e);
        }
    }

    private GeneratedClassEntry makeClass(CodeGenerator<?> cg) throws Exception {
        ++this.cacheMissCount;
        return new GeneratedClassEntry(this.codeGenCompiler.compile(cg));
    }

    @VisibleForTesting
    public void flushCache() {
        this.cache.invalidateAll();
    }

    public void close() {
        int hitRate = 0;
        if (this.classGenCount > 0) {
            hitRate = (int)Math.round((double)(this.classGenCount - this.cacheMissCount) * 100.0 / (double)this.classGenCount);
        }
        logger.info(String.format("Stats: code gen count: %d, cache miss count: %d, hit rate: %d%%", this.classGenCount, this.cacheMissCount, hitRate));
    }

    private class GeneratedClassEntry {
        private final Class<?> clazz;

        public GeneratedClassEntry(Class<?> clazz) {
            this.clazz = clazz;
        }
    }

    public static class CodeGenCompiler {
        private final ClassTransformer transformer;
        private final ClassBuilder classBuilder;

        public CodeGenCompiler(DrillConfig config, OptionSet optionManager) {
            this.transformer = new ClassTransformer(config, optionManager);
            this.classBuilder = new ClassBuilder(config, optionManager);
        }

        public Class<?> compile(CodeGenerator<?> cg) throws Exception {
            if (cg.isPlainJava()) {
                logger.trace(String.format("Class %s generated as plain Java", cg.getClassName()));
                return this.classBuilder.getImplementationClass(cg);
            }
            logger.trace(String.format("Class %s generated via byte-code manipulation", cg.getClassName()));
            return this.transformer.getImplementationClass(cg);
        }

        public Class<?> generateAndCompile(CodeGenerator<?> cg) throws Exception {
            cg.generate();
            return this.compile(cg);
        }
    }

    private class Loader
    extends CacheLoader<CodeGenerator<?>, GeneratedClassEntry> {
        private Loader() {
        }

        @Override
        public GeneratedClassEntry load(CodeGenerator<?> cg) throws Exception {
            return CodeCompiler.this.makeClass(cg);
        }
    }
}

