/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.io.IOException;
import java.io.Writer;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.log4j.Level;
import org.slf4j.Logger;

public class LogWriter
extends Writer {
    private final Logger logger;
    private final int level;
    private final StringBuilder stringBuilder;
    private boolean isClosed;

    public LogWriter(Logger logger, Level level) {
        Preconditions.checkNotNull(logger);
        Preconditions.checkArgument(level == Level.DEBUG || level == Level.ERROR || level == Level.INFO || level == Level.TRACE || level == Level.WARN, "level must be a logging level");
        this.logger = logger;
        this.level = level.toInt();
        this.stringBuilder = new StringBuilder(80);
        this.isClosed = false;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int newlinePos;
        this.checkNotClosed();
        this.stringBuilder.append(cbuf, off, len);
        while ((newlinePos = this.stringBuilder.indexOf("\n")) >= 0) {
            String oneLine = this.stringBuilder.substring(0, newlinePos);
            this.writeToLog(oneLine);
            this.stringBuilder.delete(0, newlinePos + 1);
            if (this.stringBuilder.length() > 0) continue;
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkNotClosed();
        this.flushToLog();
    }

    @Override
    public void close() throws IOException {
        this.checkNotClosed();
        this.isClosed = true;
        this.flushToLog();
    }

    private void flushToLog() {
        this.writeToLog(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
    }

    private void writeToLog(String s) {
        if (s == null || s.isEmpty()) {
            return;
        }
        switch (this.level) {
            case 10000: {
                this.logger.debug(s);
                break;
            }
            case 40000: {
                this.logger.error(s);
                break;
            }
            case 20000: {
                this.logger.info(s);
                break;
            }
            case 5000: {
                this.logger.trace(s);
                break;
            }
            case 30000: {
                this.logger.warn(s);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("LogWriter is already closed()");
        }
    }
}

