/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.drill.exec.compile.AsmUtil;
import org.apache.drill.exec.compile.CheckClassVisitorFsm;
import org.apache.drill.exec.compile.CheckMethodVisitorFsm;
import org.apache.drill.exec.compile.ClassTransformer;
import org.apache.drill.exec.compile.DrillCheckClassAdapter;
import org.apache.drill.exec.compile.DrillInitMethodVisitor;
import org.apache.drill.exec.compile.bytecode.ValueHolderReplacementVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.MethodRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MergeAdapter
extends ClassVisitor {
    private static final Logger logger = LoggerFactory.getLogger(MergeAdapter.class);
    private final ClassNode classToMerge;
    private final ClassTransformer.ClassSet set;
    private final Set<String> mergingNames = new HashSet<String>();
    private final boolean hasInit;
    private String name;
    private static final boolean verifyBytecode = true;

    private MergeAdapter(ClassTransformer.ClassSet set, ClassVisitor cv, ClassNode cn) {
        super(589824, cv);
        this.classToMerge = cn;
        this.set = set;
        boolean hasInit = false;
        for (MethodNode methodNode : this.classToMerge.methods) {
            String name = methodNode.name;
            if (name.equals("<init>")) continue;
            if (name.equals("__DRILL_INIT__")) {
                hasInit = true;
            }
            this.mergingNames.add(name);
        }
        this.hasInit = hasInit;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (name.startsWith(this.set.precompiled.slash)) {
            name = name.replace(this.set.precompiled.slash, this.set.generated.slash);
            int i = name.lastIndexOf(36);
            outerName = name.substring(0, i);
        }
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.name = name;
        if (!name.contains("$")) {
            access = access ^ 0x400 | 0x10;
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x400) != 0 || this.mergingNames.contains(name)) {
            return null;
        }
        if (signature != null) {
            signature = signature.replace(this.set.precompiled.slash, this.set.generated.slash);
        }
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("<init>") && this.hasInit) {
            return new DrillInitMethodVisitor(this.name, mv);
        }
        return mv;
    }

    public void visitEnd() {
        this.classToMerge.fields.stream().filter(field -> !field.name.startsWith("this$")).forEach(field -> field.accept((ClassVisitor)this));
        for (MethodNode mn : this.classToMerge.methods) {
            if (mn.name.equals("<init>")) continue;
            String[] exceptions = new String[mn.exceptions.size()];
            mn.exceptions.toArray(exceptions);
            MethodVisitor mv = this.cv.visitMethod(mn.access | 0x10, mn.name, mn.desc, mn.signature, exceptions);
            mv = new CheckMethodVisitorFsm(this.api, mv);
            mn.instructions.resetLabels();
            ClassTransformer.ClassSet top = this.set;
            while (top.parent != null) {
                top = top.parent;
            }
            mn.accept((MethodVisitor)new MethodRemapper(mv, (Remapper)new SimpleRemapper(top.precompiled.slash, top.generated.slash)));
        }
        super.visitEnd();
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return super.visitField(access, name, desc, signature, value);
    }

    public static MergedClassResult getMergedClass(ClassTransformer.ClassSet set, byte[] precompiledClass, ClassNode generatedClass, boolean scalarReplace) {
        if (!AsmUtil.isClassBytesOk(logger, "precompiledClass", precompiledClass)) {
            throw new IllegalStateException("Problem found in precompiledClass");
        }
        if (generatedClass != null && !AsmUtil.isClassOk(logger, "generatedClass", generatedClass)) {
            throw new IllegalStateException("Problem found in generatedClass");
        }
        RemapClasses re = new RemapClasses(set);
        try {
            ClassWriter writer;
            if (scalarReplace && generatedClass != null) {
                ClassNode generatedMerged;
                if (logger.isDebugEnabled()) {
                    AsmUtil.logClass(logger, "generated " + set.generated.dot, generatedClass);
                }
                Object mergeGenerator = generatedMerged = new ClassNode();
                mergeGenerator = new DrillCheckClassAdapter(589824, new CheckClassVisitorFsm(589824, (ClassVisitor)generatedMerged), true);
                generatedClass.accept((ClassVisitor)new ValueHolderReplacementVisitor((ClassVisitor)mergeGenerator, true));
                if (!AsmUtil.isClassOk(logger, "generatedMerged", generatedMerged)) {
                    throw new IllegalStateException("Problem found with generatedMerged");
                }
                generatedClass = generatedMerged;
            }
            Object writerVisitor = writer = new ClassWriter(2);
            writerVisitor = new DrillCheckClassAdapter(589824, new CheckClassVisitorFsm(589824, (ClassVisitor)writerVisitor), true);
            Object remappingAdapter = new ClassRemapper((ClassVisitor)writerVisitor, (Remapper)re);
            Object visitor = remappingAdapter = new DrillCheckClassAdapter(589824, new CheckClassVisitorFsm(589824, (ClassVisitor)remappingAdapter), true);
            if (generatedClass != null) {
                visitor = new MergeAdapter(set, (ClassVisitor)remappingAdapter, generatedClass);
            }
            ClassReader tReader = new ClassReader(precompiledClass);
            tReader.accept((ClassVisitor)visitor, 4);
            byte[] outputClass = writer.toByteArray();
            if (logger.isDebugEnabled()) {
                AsmUtil.logClassFromBytes(logger, "merged " + set.generated.dot, outputClass);
            }
            return new MergedClassResult(outputClass, re.getInnerClasses());
        }
        catch (Error | RuntimeException e) {
            logger.error("Failure while merging classes.", e);
            AsmUtil.logClass(logger, "generatedClass", generatedClass);
            throw e;
        }
    }

    private static class RemapClasses
    extends Remapper {
        private final Set<String> innerClasses = new HashSet<String>();
        private final ClassTransformer.ClassSet top;
        private final ClassTransformer.ClassSet current;

        public RemapClasses(ClassTransformer.ClassSet set) {
            this.current = set;
            ClassTransformer.ClassSet top = set;
            while (top.parent != null) {
                top = top.parent;
            }
            this.top = top;
        }

        public String map(String typeName) {
            if (typeName.startsWith(this.top.precompiled.slash)) {
                if (typeName.startsWith(this.current.precompiled.slash + "$")) {
                    this.innerClasses.add(typeName);
                }
                return typeName.replace(this.top.precompiled.slash, this.top.generated.slash);
            }
            return typeName;
        }

        public Set<String> getInnerClasses() {
            return this.innerClasses;
        }
    }

    public static class MergedClassResult {
        public final byte[] bytes;
        public final Collection<String> innerClasses;

        public MergedClassResult(byte[] bytes, Collection<String> innerClasses) {
            this.bytes = bytes;
            this.innerClasses = innerClasses;
        }
    }
}

