/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.compile.ClassCompilerSelector;
import org.apache.drill.exec.compile.ClassTransformer;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.shaded.guava.com.google.common.collect.MapMaker;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryClassLoader
extends URLClassLoader {
    static final Logger logger = LoggerFactory.getLogger(QueryClassLoader.class);
    private ClassCompilerSelector compilerSelector;
    private AtomicLong index = new AtomicLong(0L);
    private ConcurrentMap<String, byte[]> customClasses = new MapMaker().concurrencyLevel(4).makeMap();

    public QueryClassLoader(DrillConfig config, OptionSet sessionOptions) {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
        this.compilerSelector = new ClassCompilerSelector(this, config, sessionOptions);
    }

    public long getNextClassIndex() {
        return this.index.getAndIncrement();
    }

    public void injectByteCode(String className, byte[] classBytes) throws IOException {
        if (this.customClasses.containsKey(className)) {
            throw new IOException(String.format("The class defined %s has already been loaded.", className));
        }
        this.customClasses.put(className, classBytes);
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        byte[] ba = (byte[])this.customClasses.get(className);
        if (ba != null) {
            return this.defineClass(className, ba, 0, ba.length);
        }
        return super.findClass(className);
    }

    public byte[][] getClassByteCode(ClassTransformer.ClassNames className, String sourceCode) throws CompileException, IOException, ClassNotFoundException, ClassTransformationException {
        return this.compilerSelector.getClassByteCode(className, sourceCode);
    }
}

