/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.drill.exec.compile.sig.SignatureHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateClassDefinition<T> {
    static final Logger logger = LoggerFactory.getLogger(TemplateClassDefinition.class);
    private final Class<T> iface;
    private final Class<? extends T> template;
    private final SignatureHolder signature;
    private static final AtomicLong classNumber = new AtomicLong(0L);

    public <X extends T> TemplateClassDefinition(Class<T> iface, Class<X> template) {
        this.iface = iface;
        this.template = template;
        SignatureHolder holder = null;
        try {
            holder = SignatureHolder.getHolder(template);
        }
        catch (Exception ex) {
            logger.error("Failure while trying to build signature holder for signature. {}", (Object)template.getName(), (Object)ex);
        }
        this.signature = holder;
    }

    public long getNextClassNumber() {
        return classNumber.getAndIncrement();
    }

    public Class<T> getExternalInterface() {
        return this.iface;
    }

    public Class<? extends T> getTemplateClass() {
        return this.template;
    }

    public String getTemplateClassName() {
        return this.template.getName();
    }

    public SignatureHolder getSignature() {
        return this.signature;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("TemplateClassDefinition [interface=");
        buf.append(this.iface == null ? "null" : this.iface.getName());
        buf.append(", template=");
        buf.append(this.template == null ? "null" : this.template.getName());
        buf.append(", signature=\n");
        buf.append(this.signature);
        buf.append("]");
        return buf.toString();
    }
}

