/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.bytecode;

import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import java.util.HashMap;
import org.apache.drill.exec.compile.bytecode.DirectSorter;
import org.apache.drill.exec.compile.bytecode.ReplacingBasicValue;
import org.apache.drill.exec.compile.bytecode.TrackingInstructionList;
import org.apache.drill.exec.compile.bytecode.ValueHolderIden;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstructionModifier
extends MethodVisitor {
    private static final Logger logger = LoggerFactory.getLogger(InstructionModifier.class);
    private final IntObjectHashMap<ValueHolderIden.ValueHolderSub> oldToNew = new IntObjectHashMap();
    private final IntIntHashMap oldLocalToFirst = new IntIntHashMap();
    private final DirectSorter adder;
    private int lastLineNumber = 0;
    private final TrackingInstructionList list;
    private final String name;
    private final String desc;
    private final String signature;
    private int stackIncrease = 0;

    public InstructionModifier(int access, String name, String desc, String signature, String[] exceptions, TrackingInstructionList list, MethodVisitor inner) {
        super(589824, (MethodVisitor)new DirectSorter(access, desc, inner));
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.list = list;
        this.adder = (DirectSorter)this.mv;
    }

    public int getLastLineNumber() {
        return this.lastLineNumber;
    }

    private static ReplacingBasicValue filterReplacement(BasicValue basicValue) {
        ReplacingBasicValue replacingValue;
        if (basicValue instanceof ReplacingBasicValue && (replacingValue = (ReplacingBasicValue)basicValue).isReplaceable()) {
            return replacingValue;
        }
        return null;
    }

    private ReplacingBasicValue getLocal(int var) {
        BasicValue basicValue = (BasicValue)this.list.currentFrame.getLocal(var);
        return InstructionModifier.filterReplacement(basicValue);
    }

    private ReplacingBasicValue peekFromTop(int depth) {
        Preconditions.checkArgument(depth >= 0);
        Frame<BasicValue> frame = this.list.currentFrame;
        BasicValue basicValue = (BasicValue)frame.getStack(frame.getStackSize() - 1 - depth);
        return InstructionModifier.filterReplacement(basicValue);
    }

    private ReplacingBasicValue getFunctionReturn() {
        Frame<BasicValue> nextFrame = this.list.nextFrame;
        BasicValue basicValue = (BasicValue)nextFrame.getStack(nextFrame.getStackSize() - 1);
        return InstructionModifier.filterReplacement(basicValue);
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 89: {
                if (this.peekFromTop(0) == null) break;
                return;
            }
            case 90: {
                ReplacingBasicValue rbValue = this.peekFromTop(1);
                if (rbValue == null) break;
                super.visitInsn(89);
                return;
            }
            case 93: {
                if (this.peekFromTop(0) != null) {
                    throw new IllegalStateException("top of stack should be 2nd part of a long or double");
                }
                ReplacingBasicValue rbValue = this.peekFromTop(2);
                if (rbValue == null) break;
                super.visitInsn(92);
                return;
            }
        }
        super.visitInsn(opcode);
    }

    public void visitTypeInsn(int opcode, String type) {
        ReplacingBasicValue r = this.getFunctionReturn();
        if (r != null) {
            ValueHolderIden.ValueHolderSub sub = r.getIden().getHolderSub(this.adder);
            this.oldToNew.put(r.getIndex(), (Object)sub);
        } else {
            super.visitTypeInsn(opcode, type);
        }
    }

    public void visitLineNumber(int line, Label start) {
        this.lastLineNumber = line;
        super.visitLineNumber(line, start);
    }

    public void visitVarInsn(int opcode, int var) {
        ReplacingBasicValue v;
        if (opcode == 58 && (v = this.peekFromTop(0)) != null) {
            ValueHolderIden.ValueHolderSub sub;
            ValueHolderIden.ValueHolderSub newSub;
            ValueHolderIden.ValueHolderSub from = (ValueHolderIden.ValueHolderSub)this.oldToNew.get(v.getIndex());
            ReplacingBasicValue current = this.getLocal(var);
            if (current != null && (newSub = (ValueHolderIden.ValueHolderSub)this.oldToNew.get(current.getIndex())).iden() == from.iden()) {
                int targetFirst = newSub.first();
                from.transfer(this, targetFirst);
                return;
            }
            if (this.oldLocalToFirst.containsKey(var) && (sub = (ValueHolderIden.ValueHolderSub)this.oldToNew.get(this.oldLocalToFirst.get(var))).iden() == from.iden()) {
                from.transfer(this, sub.first());
                return;
            }
            this.oldLocalToFirst.put(var, v.getIndex());
            return;
        }
        if (opcode == 25 && (v = this.getLocal(var)) != null) {
            return;
        }
        super.visitVarInsn(opcode, var);
    }

    void directVarInsn(int opcode, int var) {
        this.adder.directVarInsn(opcode, var);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack + this.stackIncrease, maxLocals);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        int stackDepth = 0;
        switch (opcode) {
            case 181: {
                ReplacingBasicValue value = this.peekFromTop(stackDepth++);
                if (value != null) {
                    if (InstructionModifier.filterReplacement(value) == null) {
                        super.visitFieldInsn(opcode, owner, name, desc);
                        return;
                    }
                    ValueHolderIden.ValueHolderSub sub = (ValueHolderIden.ValueHolderSub)this.oldToNew.get(value.getIndex());
                    int additionalStack = sub.transferToExternal(this.adder, owner, name, desc);
                    if (additionalStack > this.stackIncrease) {
                        this.stackIncrease = additionalStack;
                    }
                    return;
                }
            }
            case 180: {
                ValueHolderIden.ValueHolderSub sub;
                ReplacingBasicValue value = this.peekFromTop(stackDepth);
                if (value == null || InstructionModifier.filterReplacement(value) == null || (sub = (ValueHolderIden.ValueHolderSub)this.oldToNew.get(value.getIndex())) == null) break;
                sub.addInsn(name, this, opcode);
                return;
            }
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        assert (false);
        throw new RuntimeException("this method is deprecated");
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        ReplacingBasicValue functionReturn;
        ReplacingBasicValue thisRef;
        int argCount = Type.getArgumentTypes((String)desc).length;
        if (opcode != 184 && (thisRef = this.peekFromTop(argCount)) != null) {
            if (name.equals("<init>")) {
                ((ValueHolderIden.ValueHolderSub)this.oldToNew.get(thisRef.getIndex())).init(this.adder);
                return;
            }
            throw new IllegalStateException("You can't call a method on a value holder.");
        }
        if (Type.getReturnType((String)desc) != Type.VOID_TYPE && (functionReturn = this.getFunctionReturn()) != null) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            functionReturn.markFunctionReturn();
            return;
        }
        for (int argDepth = argCount - 1; argDepth >= 0; --argDepth) {
            ReplacingBasicValue argValue = this.peekFromTop(argDepth);
            if (argValue == null) continue;
            throw new IllegalStateException(String.format("Holder types are not allowed to be passed between methods. Ran across problem attempting to invoke method '%s' on line number %d", name, this.lastLineNumber));
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    public void visitEnd() {
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("InstructionModifier ");
            sb.append(this.name);
            sb.append(' ');
            sb.append(this.signature);
            sb.append('\n');
            if (this.desc != null && !this.desc.isEmpty()) {
                sb.append("  desc: ");
                sb.append(this.desc);
                sb.append('\n');
            }
            int idenId = 0;
            int itemCount = 0;
            HashMap<ValueHolderIden, Integer> seenIdens = new HashMap<ValueHolderIden, Integer>();
            sb.append(" .oldToNew:\n");
            for (IntObjectCursor ioc : this.oldToNew) {
                ValueHolderIden iden = ((ValueHolderIden.ValueHolderSub)ioc.value).iden();
                if (!seenIdens.containsKey(iden)) {
                    seenIdens.put(iden, ++idenId);
                    sb.append("ValueHolderIden[" + idenId + "]:\n");
                    iden.dump(sb);
                }
                sb.append("  " + ioc.key + " => " + ioc.value + '[' + seenIdens.get(iden) + "]\n");
                ++itemCount;
            }
            sb.append(" .oldLocalToFirst:\n");
            for (IntIntCursor iic : this.oldLocalToFirst) {
                sb.append("  " + iic.key + " => " + iic.value + '\n');
                ++itemCount;
            }
            if (itemCount > 0) {
                logger.debug(sb.toString());
            }
        }
        super.visitEnd();
    }
}

