/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.bytecode;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.drill.exec.compile.bytecode.ValueHolderIden;
import org.apache.drill.exec.util.AssertionUtil;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.BasicValue;

public class ReplacingBasicValue
extends BasicValue {
    private final ValueHolderIden iden;
    private final int index;
    private FlagSet flagSet;
    private IdentityHashMap<ReplacingBasicValue, ReplacingBasicValue> associates = null;
    private HashSet<Integer> frameSlots = null;

    public static ReplacingBasicValue create(Type type, ValueHolderIden iden, int index, List<ReplacingBasicValue> valueList) {
        ReplacingBasicValue replacingValue = new ReplacingBasicValue(type, iden, index);
        valueList.add(replacingValue);
        return replacingValue;
    }

    private static void indent(StringBuilder sb, int indentLevel) {
        for (int i = 0; i < indentLevel; ++i) {
            sb.append(' ');
        }
    }

    public void dump(StringBuilder sb, int indentLevel) {
        ReplacingBasicValue.indent(sb, indentLevel);
        if (this.iden != null) {
            this.iden.dump(sb);
        } else {
            sb.append("iden is null");
        }
        sb.append('\n');
        ReplacingBasicValue.indent(sb, indentLevel + 1);
        sb.append(" index: " + this.index);
        sb.append(' ');
        this.flagSet.dump(sb);
        sb.append(" frameSlots: ");
        this.dumpFrameSlots(sb);
        sb.append('\n');
        if (this.associates != null) {
            ReplacingBasicValue.indent(sb, indentLevel);
            sb.append("associates(index)");
            for (ReplacingBasicValue value : this.associates.keySet()) {
                sb.append(' ');
                sb.append(value.index);
            }
            sb.append('\n');
        }
    }

    private ReplacingBasicValue(Type type, ValueHolderIden iden, int index) {
        super(type);
        this.iden = iden;
        this.index = index;
        this.flagSet = new FlagSet();
    }

    public boolean isReplaceable() {
        return this.flagSet.isReplaceable();
    }

    private void dumpFrameSlots(StringBuilder sb) {
        if (this.frameSlots != null) {
            boolean first = true;
            for (Integer i : this.frameSlots) {
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                sb.append(i);
            }
        }
    }

    public void setFrameSlot(int frameSlot) {
        if (this.frameSlots == null) {
            this.frameSlots = new HashSet();
        }
        this.frameSlots.add(frameSlot);
    }

    private void addOther(ReplacingBasicValue other) {
        assert (other.associates == null);
        this.associates.put(other, null);
        other.associates = this.associates;
        this.flagSet.mergeFrom(other.flagSet);
        other.flagSet = this.flagSet;
    }

    public void associate(ReplacingBasicValue other) {
        this.associate0(other);
        if (AssertionUtil.ASSERT_ENABLED) {
            assert (this.associates == other.associates);
            assert (this.flagSet == other.flagSet);
            if (this.associates != null) {
                assert (this.associates.containsKey((Object)this));
                assert (this.associates.containsKey((Object)other));
                for (ReplacingBasicValue value : this.associates.keySet()) {
                    assert (this.associates.get((Object)value) == null);
                    assert (value.associates == this.associates);
                    assert (value.flagSet == this.flagSet);
                }
            }
        }
    }

    private void associate0(ReplacingBasicValue other) {
        if (this == other) {
            return;
        }
        if (this.associates == null) {
            if (other.associates != null) {
                other.associate(this);
                return;
            }
            this.associates = new IdentityHashMap();
            this.associates.put(this, null);
            this.addOther(other);
            return;
        }
        if (other.associates == null) {
            this.addOther(other);
            return;
        }
        if (this.associates.containsKey((Object)other)) {
            return;
        }
        IdentityHashMap<ReplacingBasicValue, ReplacingBasicValue> largerSet = this.associates;
        FlagSet largerFlags = this.flagSet;
        IdentityHashMap<ReplacingBasicValue, ReplacingBasicValue> smallerSet = other.associates;
        FlagSet smallerFlags = other.flagSet;
        if (largerSet.size() < smallerSet.size()) {
            IdentityHashMap<ReplacingBasicValue, ReplacingBasicValue> tempSet = largerSet;
            largerSet = smallerSet;
            smallerSet = tempSet;
            FlagSet tempFlags = largerFlags;
            largerFlags = smallerFlags;
            smallerFlags = tempFlags;
        }
        largerFlags.mergeFrom(smallerFlags);
        int largerSize = largerSet.size();
        for (ReplacingBasicValue value : smallerSet.keySet()) {
            value.flagSet = largerFlags;
            value.associates = largerSet;
            largerSet.put(value, null);
        }
        assert (this.associates == largerSet);
        assert (largerSet.size() == largerSize + smallerSet.size());
        assert (this.flagSet == largerFlags);
        assert (largerSet.containsKey((Object)this));
        assert (other.associates == largerSet);
        assert (other.flagSet == largerFlags);
        assert (largerSet.containsKey((Object)other));
    }

    public void markFunctionReturn() {
        this.flagSet.isFunctionReturn = true;
    }

    public void disableFunctionReturn() {
        this.flagSet.isFunctionReturn = false;
    }

    public boolean isFunctionReturn() {
        return this.flagSet.isFunctionReturn;
    }

    public void setFunctionArgument() {
        this.flagSet.isFunctionArgument = true;
    }

    public boolean isFunctionArgument() {
        return this.flagSet.isFunctionArgument;
    }

    public void setAssignedToMember() {
        this.flagSet.isAssignedToMember = true;
    }

    public void setAssignedInConditionalBlock() {
        this.flagSet.isAssignedInConditionalBlock = true;
    }

    public boolean isAssignedToMember() {
        return this.flagSet.isAssignedToMember;
    }

    public boolean isAssignedInConditionalBlock() {
        return this.flagSet.isAssignedInConditionalBlock;
    }

    public ValueHolderIden getIden() {
        return this.iden;
    }

    public int getIndex() {
        return this.index;
    }

    public void setThis() {
        this.flagSet.isThis = true;
    }

    public boolean isThis() {
        return this.flagSet.isThis;
    }

    private static class FlagSet {
        boolean isFunctionReturn = false;
        boolean isFunctionArgument = false;
        boolean isAssignedToMember = false;
        boolean isAssignedInConditionalBlock = false;
        boolean isThis = false;

        private FlagSet() {
        }

        public void mergeFrom(FlagSet other) {
            if (other.isFunctionReturn) {
                this.isFunctionReturn = true;
            }
            if (other.isFunctionArgument) {
                this.isFunctionArgument = true;
            }
            if (other.isAssignedToMember) {
                this.isAssignedToMember = true;
            }
            if (other.isAssignedInConditionalBlock) {
                this.isAssignedInConditionalBlock = true;
            }
            if (other.isThis) {
                this.isThis = true;
            }
        }

        public boolean isReplaceable() {
            return !this.isFunctionReturn && !this.isFunctionArgument && !this.isAssignedToMember && !this.isAssignedInConditionalBlock && !this.isThis;
        }

        public void dump(StringBuilder sb) {
            boolean needSpace = false;
            if (this.isFunctionReturn) {
                sb.append("return");
                needSpace = true;
            }
            if (this.isFunctionArgument) {
                if (needSpace) {
                    sb.append(' ');
                }
                sb.append("argument");
                needSpace = true;
            }
            if (this.isAssignedToMember) {
                if (needSpace) {
                    sb.append(' ');
                }
                sb.append("member");
                needSpace = true;
            }
            if (this.isAssignedInConditionalBlock) {
                if (needSpace) {
                    sb.append(' ');
                }
                sb.append("conditional");
                needSpace = true;
            }
            if (this.isThis) {
                if (needSpace) {
                    sb.append(' ');
                }
                sb.append("this");
            }
        }
    }
}

