/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.bytecode;

import java.util.List;
import org.apache.drill.exec.compile.bytecode.ReplacingBasicValue;
import org.apache.drill.exec.compile.bytecode.ScalarReplacementTypes;
import org.apache.drill.exec.compile.bytecode.ValueHolderIden;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;

public class ReplacingInterpreter
extends BasicInterpreter {
    private final String className;
    private int index = 0;
    private final List<ReplacingBasicValue> valueList;
    private static final ImmutableMap<String, ValueHolderIden> HOLDERS;
    public static final ImmutableSet<String> HOLDER_DESCRIPTORS;

    public ReplacingInterpreter(String className, List<ReplacingBasicValue> valueList) {
        super(589824);
        this.className = className;
        this.valueList = valueList;
    }

    public BasicValue newValue(Type t) {
        if (t != null) {
            ValueHolderIden iden = HOLDERS.get(t.getDescriptor());
            if (iden != null) {
                ReplacingBasicValue v = ReplacingBasicValue.create(t, iden, this.index++, this.valueList);
                v.markFunctionReturn();
                return v;
            }
            if (t.getSort() == 10 && this.className.equals(t.getInternalName())) {
                ReplacingBasicValue rbValue = ReplacingBasicValue.create(t, null, 0, this.valueList);
                rbValue.setThis();
                return rbValue;
            }
        }
        return super.newValue(t);
    }

    public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        if (insn.getOpcode() == 187) {
            TypeInsnNode t = (TypeInsnNode)insn;
            ValueHolderIden iden = HOLDERS.get(t.desc);
            if (iden != null) {
                return ReplacingBasicValue.create(Type.getObjectType((String)t.desc), iden, this.index++, this.valueList);
            }
        }
        return super.newOperation(insn);
    }

    public void returnOperation(AbstractInsnNode insn, BasicValue value, BasicValue expected) {
        if (value instanceof ReplacingBasicValue) {
            ((ReplacingBasicValue)value).markFunctionReturn();
        }
    }

    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        ReplacingBasicValue possibleThis;
        if (insn.getOpcode() == 180 && value instanceof ReplacingBasicValue && (possibleThis = (ReplacingBasicValue)value).isThis()) {
            FieldInsnNode fieldInsn = (FieldInsnNode)insn;
            if (HOLDERS.get(fieldInsn.desc) != null) {
                BasicValue fetchedField = super.unaryOperation(insn, value);
                ReplacingBasicValue replacingValue = ReplacingBasicValue.create(fetchedField.getType(), null, -1, this.valueList);
                replacingValue.setAssignedToMember();
                return replacingValue;
            }
        }
        return super.unaryOperation(insn, value);
    }

    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        ReplacingBasicValue possibleThis;
        if (insn.getOpcode() == 181 && value2.isReference() && value1 instanceof ReplacingBasicValue && (possibleThis = (ReplacingBasicValue)value1).isThis() && value2 instanceof ReplacingBasicValue && HOLDERS.get(value2.getType().getDescriptor()) != null) {
            ReplacingBasicValue localRef = (ReplacingBasicValue)value2;
            localRef.setAssignedToMember();
        }
        return super.binaryOperation(insn, value1, value2);
    }

    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values) throws AnalyzerException {
        if (insn instanceof MethodInsnNode) {
            boolean skipOne = insn.getOpcode() != 184;
            for (BasicValue basicValue : values) {
                if (skipOne) {
                    skipOne = false;
                    continue;
                }
                if (!(basicValue instanceof ReplacingBasicValue)) continue;
                ReplacingBasicValue argument = (ReplacingBasicValue)basicValue;
                argument.setFunctionArgument();
            }
        }
        return super.naryOperation(insn, values);
    }

    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) throws AnalyzerException {
        if (insn.getOpcode() == 83 && value3 instanceof ReplacingBasicValue) {
            ReplacingBasicValue argument = (ReplacingBasicValue)value3;
            argument.setAssignedToMember();
        }
        return super.ternaryOperation(insn, value1, value2, value3);
    }

    private static String desc(Class<?> c) {
        Type t = Type.getType(c);
        return t.getDescriptor();
    }

    static {
        ImmutableMap.Builder<String, ValueHolderIden> builder = ImmutableMap.builder();
        ImmutableSet.Builder setB = ImmutableSet.builder();
        for (Class clazz : ScalarReplacementTypes.CLASSES) {
            String desc = ReplacingInterpreter.desc(clazz);
            setB.add(desc);
            String desc2 = desc.substring(1, desc.length() - 1);
            ValueHolderIden vhi = new ValueHolderIden(clazz);
            builder.put(desc, vhi);
            builder.put(desc2, vhi);
        }
        HOLDER_DESCRIPTORS = setB.build();
        HOLDERS = builder.build();
    }
}

