/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.bytecode;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;

public class TrackingInstructionList
extends InsnList {
    Frame<BasicValue> currentFrame;
    Frame<BasicValue> nextFrame;
    AbstractInsnNode currentInsn;
    private int index = 0;
    private final Frame<BasicValue>[] frames;
    private final InsnList inner;

    public TrackingInstructionList(Frame<BasicValue>[] frames, InsnList inner) {
        this.frames = frames;
        this.inner = inner;
    }

    public void accept(MethodVisitor mv) {
        this.currentInsn = this.inner.getFirst();
        while (this.currentInsn != null) {
            this.currentFrame = this.frames[this.index];
            this.nextFrame = this.index + 1 < this.frames.length ? this.frames[this.index + 1] : null;
            this.currentInsn.accept(mv);
            this.currentInsn = this.currentInsn.getNext();
            ++this.index;
        }
    }

    public int size() {
        return this.inner.size();
    }
}

