/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.bytecode;

import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.drill.exec.compile.CheckMethodVisitorFsm;
import org.apache.drill.exec.compile.bytecode.ScalarReplacementNode;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueHolderReplacementVisitor
extends ClassVisitor {
    private static final Logger logger = LoggerFactory.getLogger(ValueHolderReplacementVisitor.class);
    private final boolean verifyBytecode;
    private String className;

    public ValueHolderReplacementVisitor(ClassVisitor cw, boolean verifyBytecode) {
        super(589824, cw);
        this.verifyBytecode = verifyBytecode;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor innerVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.verifyBytecode) {
            innerVisitor = new CheckMethodVisitorFsm(this.api, innerVisitor);
        }
        return new ScalarReplacementNode(this.className, access, name, desc, signature, exceptions, innerVisitor, this.verifyBytecode);
    }

    private static class Debugger
    extends MethodNode {
        MethodVisitor inner;

        public Debugger(int access, String name, String desc, String signature, String[] exceptions, MethodVisitor inner) {
            super(589824, access, name, desc, signature, exceptions);
            this.inner = inner;
        }

        public void visitEnd() {
            try {
                this.accept(this.inner);
                super.visitEnd();
            }
            catch (Exception e) {
                Textifier t = new Textifier();
                this.accept((MethodVisitor)new TraceMethodVisitor((Printer)t));
                StringBuilderWriter sw = new StringBuilderWriter();
                PrintWriter pw = new PrintWriter((Writer)sw);
                t.print(pw);
                pw.flush();
                String bytecode = sw.getBuilder().toString();
                logger.error(String.format("Failure while rendering method %s, %s, %s.  ByteCode:\n %s", this.name, this.desc, this.signature, bytecode), (Throwable)e);
                throw new RuntimeException(String.format("Failure while rendering method %s, %s, %s.  ByteCode:\n %s", this.name, this.desc, this.signature, bytecode), e);
            }
        }
    }
}

