/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.sig;

import com.thoughtworks.paranamer.AnnotationParanamer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.drill.exec.compile.sig.CodeGeneratorArgument;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGeneratorMethod
implements Iterable<CodeGeneratorArgument> {
    static final Logger logger = LoggerFactory.getLogger(CodeGeneratorMethod.class);
    private final String methodName;
    private final Class<?> returnType;
    private final CodeGeneratorArgument[] arguments;
    private final Class<?>[] exs;
    private final Method underlyingMethod;

    public CodeGeneratorMethod(String name, Class<?> returnType) {
        this.methodName = name;
        this.returnType = returnType;
        this.exs = new Class[0];
        this.underlyingMethod = null;
        this.arguments = new CodeGeneratorArgument[0];
    }

    public CodeGeneratorMethod(Method m) {
        this.underlyingMethod = m;
        this.methodName = m.getName();
        this.returnType = m.getReturnType();
        AnnotationParanamer para = new AnnotationParanamer();
        Object[] parameterNames = para.lookupParameterNames((AccessibleObject)m, true);
        if (parameterNames == null) {
            throw new RuntimeException(String.format("Unable to read the parameter names for method %s.  This is likely due to the class files not including the appropriate debugging information.  Look up java -g for more information.", m));
        }
        Object[] types = m.getParameterTypes();
        if (parameterNames.length != types.length) {
            throw new RuntimeException(String.format("Unexpected number of parameter names %s.  Expected %s on method %s.", Arrays.toString(parameterNames), Arrays.toString(types), m.toGenericString()));
        }
        this.arguments = new CodeGeneratorArgument[parameterNames.length];
        for (int i = 0; i < parameterNames.length; ++i) {
            this.arguments[i] = new CodeGeneratorArgument((String)parameterNames[i], (Class<?>)types[i]);
        }
        this.exs = m.getExceptionTypes();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Iterable<Class<?>> getThrowsIterable() {
        return ImmutableList.copyOf(this.exs);
    }

    @Override
    public Iterator<CodeGeneratorArgument> iterator() {
        return Iterators.forArray(this.arguments);
    }

    public String toString() {
        return "CodeGeneratorMethod [" + (this.underlyingMethod == null ? "null" : this.underlyingMethod.toGenericString()) + "]";
    }
}

