/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.sig;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Set;
import org.apache.drill.common.expression.AnyValueExpression;
import org.apache.drill.common.expression.BooleanOperator;
import org.apache.drill.common.expression.CastExpression;
import org.apache.drill.common.expression.ConvertExpression;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.common.expression.IfExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.NullExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.TypedFieldExpr;
import org.apache.drill.common.expression.TypedNullConstant;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class ConstantExpressionIdentifier
implements ExprVisitor<Boolean, IdentityHashMap<LogicalExpression, Object>, RuntimeException> {
    private ConstantExpressionIdentifier() {
    }

    public static Set<LogicalExpression> getConstantExpressionSet(LogicalExpression e) {
        ConstantExpressionIdentifier visitor = new ConstantExpressionIdentifier();
        IdentityHashMap<LogicalExpression, Boolean> map = new IdentityHashMap<LogicalExpression, Boolean>();
        if (e.accept(visitor, map).booleanValue() && map.isEmpty()) {
            map.put(e, true);
            return map.keySet();
        }
        if (map.isEmpty()) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    private boolean checkChildren(LogicalExpression e, IdentityHashMap<LogicalExpression, Object> value, boolean transmitsConstant) {
        LinkedList<LogicalExpression> constants = Lists.newLinkedList();
        boolean constant = true;
        for (LogicalExpression child : e) {
            if (child.accept(this, value).booleanValue()) {
                constants.add(child);
                continue;
            }
            constant = false;
        }
        if (!constant || !transmitsConstant) {
            for (LogicalExpression c : constants) {
                value.put(c, true);
            }
        }
        return constant && transmitsConstant;
    }

    @Override
    public Boolean visitFunctionCall(FunctionCall call, IdentityHashMap<LogicalExpression, Object> value) {
        throw new UnsupportedOperationException("FunctionCall is not expected here. It should have been converted to FunctionHolderExpression in materialization");
    }

    @Override
    public Boolean visitFunctionHolderExpression(FunctionHolderExpression holder, IdentityHashMap<LogicalExpression, Object> value) throws RuntimeException {
        return this.checkChildren(holder, value, !holder.isAggregating() && !holder.isRandom() && !holder.getHolder().isComplexWriterFuncHolder());
    }

    @Override
    public Boolean visitBooleanOperator(BooleanOperator op, IdentityHashMap<LogicalExpression, Object> value) throws RuntimeException {
        return this.checkChildren(op, value, true);
    }

    @Override
    public Boolean visitIfExpression(IfExpression ifExpr, IdentityHashMap<LogicalExpression, Object> value) {
        return this.checkChildren(ifExpr, value, true);
    }

    @Override
    public Boolean visitSchemaPath(SchemaPath path, IdentityHashMap<LogicalExpression, Object> value) {
        return false;
    }

    @Override
    public Boolean visitIntConstant(ValueExpressions.IntExpression intExpr, IdentityHashMap<LogicalExpression, Object> value) throws RuntimeException {
        return true;
    }

    @Override
    public Boolean visitFloatConstant(ValueExpressions.FloatExpression fExpr, IdentityHashMap<LogicalExpression, Object> value) throws RuntimeException {
        return true;
    }

    @Override
    public Boolean visitLongConstant(ValueExpressions.LongExpression intExpr, IdentityHashMap<LogicalExpression, Object> value) {
        return true;
    }

    @Override
    public Boolean visitDateConstant(ValueExpressions.DateExpression intExpr, IdentityHashMap<LogicalExpression, Object> value) {
        return true;
    }

    @Override
    public Boolean visitDecimal9Constant(ValueExpressions.Decimal9Expression decExpr, IdentityHashMap<LogicalExpression, Object> value) {
        return true;
    }

    @Override
    public Boolean visitTimeConstant(ValueExpressions.TimeExpression intExpr, IdentityHashMap<LogicalExpression, Object> value) {
        return true;
    }

    @Override
    public Boolean visitDecimal18Constant(ValueExpressions.Decimal18Expression decExpr, IdentityHashMap<LogicalExpression, Object> value) {
        return true;
    }

    @Override
    public Boolean visitIntervalYearConstant(ValueExpressions.IntervalYearExpression intExpr, IdentityHashMap<LogicalExpression, Object> value) {
        return true;
    }

    @Override
    public Boolean visitDecimal28Constant(ValueExpressions.Decimal28Expression decExpr, IdentityHashMap<LogicalExpression, Object> value) {
        return true;
    }

    @Override
    public Boolean visitIntervalDayConstant(ValueExpressions.IntervalDayExpression intExpr, IdentityHashMap<LogicalExpression, Object> value) {
        return true;
    }

    @Override
    public Boolean visitTimeStampConstant(ValueExpressions.TimeStampExpression intExpr, IdentityHashMap<LogicalExpression, Object> value) {
        return true;
    }

    @Override
    public Boolean visitDecimal38Constant(ValueExpressions.Decimal38Expression decExpr, IdentityHashMap<LogicalExpression, Object> value) {
        return true;
    }

    @Override
    public Boolean visitVarDecimalConstant(ValueExpressions.VarDecimalExpression decExpr, IdentityHashMap<LogicalExpression, Object> value) {
        return true;
    }

    @Override
    public Boolean visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, IdentityHashMap<LogicalExpression, Object> value) {
        return true;
    }

    @Override
    public Boolean visitBooleanConstant(ValueExpressions.BooleanExpression e, IdentityHashMap<LogicalExpression, Object> value) {
        return true;
    }

    @Override
    public Boolean visitQuotedStringConstant(ValueExpressions.QuotedString e, IdentityHashMap<LogicalExpression, Object> value) {
        return true;
    }

    @Override
    public Boolean visitCastExpression(CastExpression e, IdentityHashMap<LogicalExpression, Object> value) throws RuntimeException {
        return e.getInput().accept(this, value);
    }

    @Override
    public Boolean visitUnknown(LogicalExpression e, IdentityHashMap<LogicalExpression, Object> value) {
        return this.checkChildren(e, value, false);
    }

    @Override
    public Boolean visitNullConstant(TypedNullConstant e, IdentityHashMap<LogicalExpression, Object> value) throws RuntimeException {
        return true;
    }

    @Override
    public Boolean visitNullExpression(NullExpression e, IdentityHashMap<LogicalExpression, Object> value) throws RuntimeException {
        return true;
    }

    @Override
    public Boolean visitConvertExpression(ConvertExpression e, IdentityHashMap<LogicalExpression, Object> value) throws RuntimeException {
        return e.getInput().accept(this, value);
    }

    @Override
    public Boolean visitAnyValueExpression(AnyValueExpression e, IdentityHashMap<LogicalExpression, Object> value) throws RuntimeException {
        return e.getInput().accept(this, value);
    }

    @Override
    public Boolean visitParameter(ValueExpressions.ParameterExpression e, IdentityHashMap<LogicalExpression, Object> value) throws RuntimeException {
        return false;
    }

    @Override
    public Boolean visitTypedFieldExpr(TypedFieldExpr e, IdentityHashMap<LogicalExpression, Object> value) throws RuntimeException {
        return false;
    }
}

