/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.sig;

import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorMapping {
    static final Logger logger = LoggerFactory.getLogger(GeneratorMapping.class);
    private final String setup;
    private final String eval;
    private final String reset;
    private final String cleanup;

    public GeneratorMapping(String setup, String eval, String reset, String cleanup) {
        this.setup = setup;
        this.eval = eval;
        this.reset = reset;
        this.cleanup = cleanup;
    }

    public GeneratorMapping(GeneratorMapping gm) {
        this.setup = gm.setup;
        this.eval = gm.eval;
        this.reset = gm.reset;
        this.cleanup = gm.cleanup;
    }

    public static GeneratorMapping GM(String setup, String eval) {
        return GeneratorMapping.create(setup, eval, null, null);
    }

    public static GeneratorMapping GM(String setup, String eval, String reset, String cleanup) {
        return GeneratorMapping.create(setup, eval, reset, cleanup);
    }

    public static GeneratorMapping create(String setup, String eval, String reset, String cleanup) {
        return new GeneratorMapping(setup, eval, reset, cleanup);
    }

    public String getMethodName(ClassGenerator.BlockType type) {
        switch (type) {
            case CLEANUP: {
                Preconditions.checkNotNull(this.cleanup, "The current mapping does not have a cleanup method defined.");
                return this.cleanup;
            }
            case EVAL: {
                Preconditions.checkNotNull(this.eval, "The current mapping does not have an eval method defined.");
                return this.eval;
            }
            case RESET: {
                Preconditions.checkNotNull(this.reset, "The current mapping does not have a reset method defined.");
                return this.reset;
            }
            case SETUP: {
                Preconditions.checkNotNull(this.setup, "The current mapping does not have a setup method defined.");
                return this.setup;
            }
        }
        throw new IllegalStateException();
    }
}

