/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.sig;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.drill.exec.compile.sig.CodeGeneratorMethod;
import org.apache.drill.exec.compile.sig.RuntimeOverridden;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterators;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureHolder
implements Iterable<CodeGeneratorMethod> {
    static final Logger logger = LoggerFactory.getLogger(SignatureHolder.class);
    private final Class<?> signature;
    private final CodeGeneratorMethod[] methods;
    private final Map<String, Integer> methodMap;
    private final SignatureHolder[] childHolders;
    public static final String DRILL_INIT_METHOD = "__DRILL_INIT__";
    public static final CodeGeneratorMethod DRILL_INIT = new CodeGeneratorMethod("__DRILL_INIT__", Void.TYPE);

    public static SignatureHolder getHolder(Class<?> signature) {
        ArrayList<SignatureHolder> innerClasses = Lists.newArrayList();
        for (Class<?> inner : signature.getClasses()) {
            if (inner.isEnum()) continue;
            SignatureHolder h = SignatureHolder.getHolder(inner);
            if (h.childHolders.length <= 0 && h.methods.length <= 0) continue;
            innerClasses.add(h);
        }
        return new SignatureHolder(signature, innerClasses.toArray(new SignatureHolder[innerClasses.size()]));
    }

    private SignatureHolder(Class<?> signature, SignatureHolder[] childHolders) {
        Method[] reflectMethods;
        this.childHolders = childHolders;
        this.signature = signature;
        HashMap<String, Integer> newMap = Maps.newHashMap();
        ArrayList<CodeGeneratorMethod> methodHolders = Lists.newArrayList();
        for (Method m : reflectMethods = signature.getDeclaredMethods()) {
            if ((m.getModifiers() & 0x400) == 0 && m.getAnnotation(RuntimeOverridden.class) == null) continue;
            methodHolders.add(new CodeGeneratorMethod(m));
        }
        Collections.sort(methodHolders, new Comparator<CodeGeneratorMethod>(){

            @Override
            public int compare(CodeGeneratorMethod o1, CodeGeneratorMethod o2) {
                return o1.getMethodName().compareTo(o2.getMethodName());
            }
        });
        this.methods = new CodeGeneratorMethod[methodHolders.size() + 1];
        for (int i = 0; i < methodHolders.size(); ++i) {
            this.methods[i] = (CodeGeneratorMethod)methodHolders.get(i);
            Integer old = newMap.put(this.methods[i].getMethodName(), i);
            if (old == null) continue;
            throw new IllegalStateException(String.format("Attempting to add a method with name %s when there is already one method of that name in this class that is set to be runtime generated.", this.methods[i].getMethodName()));
        }
        this.methods[methodHolders.size()] = DRILL_INIT;
        newMap.put(DRILL_INIT.getMethodName(), methodHolders.size());
        this.methodMap = ImmutableMap.copyOf(newMap);
    }

    public Class<?> getSignatureClass() {
        return this.signature;
    }

    public CodeGeneratorMethod get(int i) {
        return this.methods[i];
    }

    @Override
    public Iterator<CodeGeneratorMethod> iterator() {
        return Iterators.forArray(this.methods);
    }

    public int size() {
        return this.methods.length;
    }

    public SignatureHolder[] getChildHolders() {
        return this.childHolders;
    }

    public int get(String method) {
        Integer meth = this.methodMap.get(method);
        if (meth == null) {
            throw new IllegalStateException(String.format("Unknown method requested of name %s.", method));
        }
        return meth;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("SignatureHolder [methods=");
        int maxLen = 10;
        for (int i = 0; i < 10 && i < this.methods.length; ++i) {
            if (i > 0) {
                buf.append(", \n");
            }
            buf.append(this.methods[i]);
        }
        buf.append("]");
        return buf.toString();
    }
}

