/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.coord;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.drill.exec.coord.DistributedSemaphore;
import org.apache.drill.exec.coord.store.TransientStore;
import org.apache.drill.exec.coord.store.TransientStoreConfig;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.work.foreman.DrillbitStatusListener;

public abstract class ClusterCoordinator
implements AutoCloseable {
    protected ConcurrentHashMap<DrillbitStatusListener, DrillbitStatusListener> listeners = new ConcurrentHashMap(16, 0.75f, 16);

    public abstract void start(long var1) throws Exception;

    public abstract RegistrationHandle register(CoordinationProtos.DrillbitEndpoint var1);

    public abstract void unregister(RegistrationHandle var1);

    public abstract Collection<CoordinationProtos.DrillbitEndpoint> getAvailableEndpoints();

    public abstract Collection<CoordinationProtos.DrillbitEndpoint> getOnlineEndPoints();

    public abstract RegistrationHandle update(RegistrationHandle var1, CoordinationProtos.DrillbitEndpoint.State var2);

    public abstract DistributedSemaphore getSemaphore(String var1, int var2);

    public abstract <V> TransientStore<V> getOrCreateTransientStore(TransientStoreConfig<V> var1);

    protected void drillbitUnregistered(Set<CoordinationProtos.DrillbitEndpoint> unregisteredBits) {
        for (DrillbitStatusListener listener : this.listeners.keySet()) {
            listener.drillbitUnregistered(unregisteredBits);
        }
    }

    protected void drillbitRegistered(Set<CoordinationProtos.DrillbitEndpoint> registeredBits) {
        for (DrillbitStatusListener listener : this.listeners.keySet()) {
            listener.drillbitRegistered(registeredBits);
        }
    }

    public void addDrillbitStatusListener(DrillbitStatusListener listener) {
        this.listeners.putIfAbsent(listener, listener);
    }

    public void removeDrillbitStatusListener(DrillbitStatusListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isDrillbitInState(CoordinationProtos.DrillbitEndpoint endpoint, CoordinationProtos.DrillbitEndpoint.State state) {
        return !endpoint.hasState() || endpoint.getState().equals(state);
    }

    public static interface RegistrationHandle {
        public CoordinationProtos.DrillbitEndpoint getEndPoint();

        public void setEndPoint(CoordinationProtos.DrillbitEndpoint var1);
    }
}

