/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.coord.store;

import org.apache.drill.exec.coord.store.TransientStoreEventType;
import org.apache.drill.shaded.guava.com.google.common.base.Objects;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class TransientStoreEvent<V> {
    private final TransientStoreEventType type;
    private final String key;
    private final V value;

    public TransientStoreEvent(TransientStoreEventType type, String key, V value) {
        this.type = Preconditions.checkNotNull(type);
        this.key = Preconditions.checkNotNull(key);
        this.value = Preconditions.checkNotNull(value);
    }

    public String getKey() {
        return this.key;
    }

    public TransientStoreEventType getType() {
        return this.type;
    }

    public V getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransientStoreEvent && obj.getClass().equals(this.getClass())) {
            TransientStoreEvent other = (TransientStoreEvent)obj;
            return Objects.equal((Object)this.type, (Object)other.type) && Objects.equal(this.key, other.key) && Objects.equal(this.value, other.value);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.type, this.key, this.value});
    }

    public static <T> TransientStoreEvent<T> of(TransientStoreEventType type, String key, T value) {
        return new TransientStoreEvent<T>(type, key, value);
    }
}

