/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.BasicTypeHelper;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.ComplexHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.Decimal28DenseHolder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal38DenseHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.DictHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;
import org.apache.drill.exec.expr.holders.ListHolder;
import org.apache.drill.exec.expr.holders.MapHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal18Holder;
import org.apache.drill.exec.expr.holders.NullableDecimal28DenseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal28SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38DenseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;
import org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.expr.holders.RepeatedBigIntHolder;
import org.apache.drill.exec.expr.holders.RepeatedBitHolder;
import org.apache.drill.exec.expr.holders.RepeatedDateHolder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal18Holder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal28DenseHolder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal28SparseHolder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal38DenseHolder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal38SparseHolder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal9Holder;
import org.apache.drill.exec.expr.holders.RepeatedDictHolder;
import org.apache.drill.exec.expr.holders.RepeatedFloat4Holder;
import org.apache.drill.exec.expr.holders.RepeatedFloat8Holder;
import org.apache.drill.exec.expr.holders.RepeatedIntHolder;
import org.apache.drill.exec.expr.holders.RepeatedIntervalDayHolder;
import org.apache.drill.exec.expr.holders.RepeatedIntervalHolder;
import org.apache.drill.exec.expr.holders.RepeatedIntervalYearHolder;
import org.apache.drill.exec.expr.holders.RepeatedListHolder;
import org.apache.drill.exec.expr.holders.RepeatedMapHolder;
import org.apache.drill.exec.expr.holders.RepeatedSmallIntHolder;
import org.apache.drill.exec.expr.holders.RepeatedTimeHolder;
import org.apache.drill.exec.expr.holders.RepeatedTimeStampHolder;
import org.apache.drill.exec.expr.holders.RepeatedTinyIntHolder;
import org.apache.drill.exec.expr.holders.RepeatedUInt1Holder;
import org.apache.drill.exec.expr.holders.RepeatedUInt2Holder;
import org.apache.drill.exec.expr.holders.RepeatedUInt4Holder;
import org.apache.drill.exec.expr.holders.RepeatedUInt8Holder;
import org.apache.drill.exec.expr.holders.RepeatedVar16CharHolder;
import org.apache.drill.exec.expr.holders.RepeatedVarBinaryHolder;
import org.apache.drill.exec.expr.holders.RepeatedVarCharHolder;
import org.apache.drill.exec.expr.holders.RepeatedVarDecimalHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.apache.drill.exec.expr.holders.UnionHolder;
import org.apache.drill.exec.expr.holders.Var16CharHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.BitVector;
import org.apache.drill.exec.vector.DateVector;
import org.apache.drill.exec.vector.Decimal18Vector;
import org.apache.drill.exec.vector.Decimal28DenseVector;
import org.apache.drill.exec.vector.Decimal28SparseVector;
import org.apache.drill.exec.vector.Decimal38DenseVector;
import org.apache.drill.exec.vector.Decimal38SparseVector;
import org.apache.drill.exec.vector.Decimal9Vector;
import org.apache.drill.exec.vector.Float4Vector;
import org.apache.drill.exec.vector.Float8Vector;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.IntervalDayVector;
import org.apache.drill.exec.vector.IntervalVector;
import org.apache.drill.exec.vector.IntervalYearVector;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.NullableDateVector;
import org.apache.drill.exec.vector.NullableDecimal18Vector;
import org.apache.drill.exec.vector.NullableDecimal28DenseVector;
import org.apache.drill.exec.vector.NullableDecimal28SparseVector;
import org.apache.drill.exec.vector.NullableDecimal38DenseVector;
import org.apache.drill.exec.vector.NullableDecimal38SparseVector;
import org.apache.drill.exec.vector.NullableDecimal9Vector;
import org.apache.drill.exec.vector.NullableFloat4Vector;
import org.apache.drill.exec.vector.NullableFloat8Vector;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.NullableIntervalDayVector;
import org.apache.drill.exec.vector.NullableIntervalVector;
import org.apache.drill.exec.vector.NullableIntervalYearVector;
import org.apache.drill.exec.vector.NullableSmallIntVector;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.NullableTimeVector;
import org.apache.drill.exec.vector.NullableTinyIntVector;
import org.apache.drill.exec.vector.NullableUInt1Vector;
import org.apache.drill.exec.vector.NullableUInt2Vector;
import org.apache.drill.exec.vector.NullableUInt4Vector;
import org.apache.drill.exec.vector.NullableUInt8Vector;
import org.apache.drill.exec.vector.NullableVar16CharVector;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.NullableVarDecimalVector;
import org.apache.drill.exec.vector.SmallIntVector;
import org.apache.drill.exec.vector.TimeStampVector;
import org.apache.drill.exec.vector.TimeVector;
import org.apache.drill.exec.vector.TinyIntVector;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.UInt2Vector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.UInt8Vector;
import org.apache.drill.exec.vector.UntypedNullHolder;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.Var16CharVector;
import org.apache.drill.exec.vector.VarBinaryVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.exec.vector.VarDecimalVector;
import org.apache.drill.exec.vector.accessor.BigIntAccessor;
import org.apache.drill.exec.vector.accessor.BitAccessor;
import org.apache.drill.exec.vector.accessor.DateAccessor;
import org.apache.drill.exec.vector.accessor.Decimal18Accessor;
import org.apache.drill.exec.vector.accessor.Decimal28DenseAccessor;
import org.apache.drill.exec.vector.accessor.Decimal28SparseAccessor;
import org.apache.drill.exec.vector.accessor.Decimal38DenseAccessor;
import org.apache.drill.exec.vector.accessor.Decimal38SparseAccessor;
import org.apache.drill.exec.vector.accessor.Decimal9Accessor;
import org.apache.drill.exec.vector.accessor.Float4Accessor;
import org.apache.drill.exec.vector.accessor.Float8Accessor;
import org.apache.drill.exec.vector.accessor.GenericAccessor;
import org.apache.drill.exec.vector.accessor.IntAccessor;
import org.apache.drill.exec.vector.accessor.IntervalAccessor;
import org.apache.drill.exec.vector.accessor.IntervalDayAccessor;
import org.apache.drill.exec.vector.accessor.IntervalYearAccessor;
import org.apache.drill.exec.vector.accessor.NullableBigIntAccessor;
import org.apache.drill.exec.vector.accessor.NullableBitAccessor;
import org.apache.drill.exec.vector.accessor.NullableDateAccessor;
import org.apache.drill.exec.vector.accessor.NullableDecimal18Accessor;
import org.apache.drill.exec.vector.accessor.NullableDecimal28DenseAccessor;
import org.apache.drill.exec.vector.accessor.NullableDecimal28SparseAccessor;
import org.apache.drill.exec.vector.accessor.NullableDecimal38DenseAccessor;
import org.apache.drill.exec.vector.accessor.NullableDecimal38SparseAccessor;
import org.apache.drill.exec.vector.accessor.NullableDecimal9Accessor;
import org.apache.drill.exec.vector.accessor.NullableFloat4Accessor;
import org.apache.drill.exec.vector.accessor.NullableFloat8Accessor;
import org.apache.drill.exec.vector.accessor.NullableIntAccessor;
import org.apache.drill.exec.vector.accessor.NullableIntervalAccessor;
import org.apache.drill.exec.vector.accessor.NullableIntervalDayAccessor;
import org.apache.drill.exec.vector.accessor.NullableIntervalYearAccessor;
import org.apache.drill.exec.vector.accessor.NullableSmallIntAccessor;
import org.apache.drill.exec.vector.accessor.NullableTimeAccessor;
import org.apache.drill.exec.vector.accessor.NullableTimeStampAccessor;
import org.apache.drill.exec.vector.accessor.NullableTinyIntAccessor;
import org.apache.drill.exec.vector.accessor.NullableUInt1Accessor;
import org.apache.drill.exec.vector.accessor.NullableUInt2Accessor;
import org.apache.drill.exec.vector.accessor.NullableUInt4Accessor;
import org.apache.drill.exec.vector.accessor.NullableUInt8Accessor;
import org.apache.drill.exec.vector.accessor.NullableVar16CharAccessor;
import org.apache.drill.exec.vector.accessor.NullableVarBinaryAccessor;
import org.apache.drill.exec.vector.accessor.NullableVarCharAccessor;
import org.apache.drill.exec.vector.accessor.NullableVarDecimalAccessor;
import org.apache.drill.exec.vector.accessor.SmallIntAccessor;
import org.apache.drill.exec.vector.accessor.SqlAccessor;
import org.apache.drill.exec.vector.accessor.TimeAccessor;
import org.apache.drill.exec.vector.accessor.TimeStampAccessor;
import org.apache.drill.exec.vector.accessor.TinyIntAccessor;
import org.apache.drill.exec.vector.accessor.UInt1Accessor;
import org.apache.drill.exec.vector.accessor.UInt2Accessor;
import org.apache.drill.exec.vector.accessor.UInt4Accessor;
import org.apache.drill.exec.vector.accessor.UInt8Accessor;
import org.apache.drill.exec.vector.accessor.UnionSqlAccessor;
import org.apache.drill.exec.vector.accessor.Var16CharAccessor;
import org.apache.drill.exec.vector.accessor.VarBinaryAccessor;
import org.apache.drill.exec.vector.accessor.VarCharAccessor;
import org.apache.drill.exec.vector.accessor.VarDecimalAccessor;
import org.apache.drill.exec.vector.complex.UnionVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeHelper
extends BasicTypeHelper {
    static final Logger logger = LoggerFactory.getLogger(TypeHelper.class);

    public static SqlAccessor getSqlAccessor(ValueVector vector) {
        TypeProtos.MajorType type = vector.getField().getType();
        switch (type.getMinorType()) {
            case UNION: {
                return new UnionSqlAccessor((UnionVector)vector);
            }
            case TINYINT: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new TinyIntAccessor((TinyIntVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableTinyIntAccessor((NullableTinyIntVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case UINT1: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new UInt1Accessor((UInt1Vector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableUInt1Accessor((NullableUInt1Vector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case UINT2: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new UInt2Accessor((UInt2Vector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableUInt2Accessor((NullableUInt2Vector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case SMALLINT: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new SmallIntAccessor((SmallIntVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableSmallIntAccessor((NullableSmallIntVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case INT: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new IntAccessor((IntVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableIntAccessor((NullableIntVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case UINT4: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new UInt4Accessor((UInt4Vector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableUInt4Accessor((NullableUInt4Vector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case FLOAT4: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new Float4Accessor((Float4Vector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableFloat4Accessor((NullableFloat4Vector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case TIME: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new TimeAccessor((TimeVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableTimeAccessor((NullableTimeVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case INTERVALYEAR: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new IntervalYearAccessor((IntervalYearVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableIntervalYearAccessor((NullableIntervalYearVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case DECIMAL9: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new Decimal9Accessor((Decimal9Vector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableDecimal9Accessor((NullableDecimal9Vector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case BIGINT: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new BigIntAccessor((BigIntVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableBigIntAccessor((NullableBigIntVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case UINT8: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new UInt8Accessor((UInt8Vector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableUInt8Accessor((NullableUInt8Vector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case FLOAT8: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new Float8Accessor((Float8Vector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableFloat8Accessor((NullableFloat8Vector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case DATE: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new DateAccessor((DateVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableDateAccessor((NullableDateVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case TIMESTAMP: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new TimeStampAccessor((TimeStampVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableTimeStampAccessor((NullableTimeStampVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case DECIMAL18: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new Decimal18Accessor((Decimal18Vector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableDecimal18Accessor((NullableDecimal18Vector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case INTERVALDAY: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new IntervalDayAccessor((IntervalDayVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableIntervalDayAccessor((NullableIntervalDayVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case INTERVAL: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new IntervalAccessor((IntervalVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableIntervalAccessor((NullableIntervalVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case DECIMAL28DENSE: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new Decimal28DenseAccessor((Decimal28DenseVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableDecimal28DenseAccessor((NullableDecimal28DenseVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case DECIMAL38DENSE: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new Decimal38DenseAccessor((Decimal38DenseVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableDecimal38DenseAccessor((NullableDecimal38DenseVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case DECIMAL38SPARSE: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new Decimal38SparseAccessor((Decimal38SparseVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableDecimal38SparseAccessor((NullableDecimal38SparseVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case DECIMAL28SPARSE: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new Decimal28SparseAccessor((Decimal28SparseVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableDecimal28SparseAccessor((NullableDecimal28SparseVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case VARBINARY: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new VarBinaryAccessor((VarBinaryVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableVarBinaryAccessor((NullableVarBinaryVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case VARCHAR: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new VarCharAccessor((VarCharVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableVarCharAccessor((NullableVarCharVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case VAR16CHAR: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new Var16CharAccessor((Var16CharVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableVar16CharAccessor((NullableVar16CharVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case VARDECIMAL: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new VarDecimalAccessor((VarDecimalVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableVarDecimalAccessor((NullableVarDecimalVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case BIT: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        return new BitAccessor((BitVector)vector);
                    }
                    case OPTIONAL: {
                        return new NullableBitAccessor((NullableBitVector)vector);
                    }
                    case REPEATED: {
                        return new GenericAccessor(vector);
                    }
                }
            }
            case MAP: 
            case DICT: 
            case LIST: 
            case NULL: {
                return new GenericAccessor(vector);
            }
        }
        throw new UnsupportedOperationException(TypeHelper.buildErrorMessage("find sql accessor", type));
    }

    public static JType getHolderType(JCodeModel model, TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        switch (type) {
            case UNION: {
                return model._ref(UnionHolder.class);
            }
            case DICT: {
                switch (mode) {
                    case REQUIRED: 
                    case OPTIONAL: {
                        return model._ref(DictHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedDictHolder.class);
                    }
                }
            }
            case MAP: 
            case LIST: {
                return model._ref(ComplexHolder.class);
            }
            case TINYINT: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(TinyIntHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableTinyIntHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedTinyIntHolder.class);
                    }
                }
            }
            case UINT1: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(UInt1Holder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableUInt1Holder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedUInt1Holder.class);
                    }
                }
            }
            case UINT2: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(UInt2Holder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableUInt2Holder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedUInt2Holder.class);
                    }
                }
            }
            case SMALLINT: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(SmallIntHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableSmallIntHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedSmallIntHolder.class);
                    }
                }
            }
            case INT: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(IntHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableIntHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedIntHolder.class);
                    }
                }
            }
            case UINT4: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(UInt4Holder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableUInt4Holder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedUInt4Holder.class);
                    }
                }
            }
            case FLOAT4: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(Float4Holder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableFloat4Holder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedFloat4Holder.class);
                    }
                }
            }
            case TIME: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(TimeHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableTimeHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedTimeHolder.class);
                    }
                }
            }
            case INTERVALYEAR: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(IntervalYearHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableIntervalYearHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedIntervalYearHolder.class);
                    }
                }
            }
            case DECIMAL9: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(Decimal9Holder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableDecimal9Holder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedDecimal9Holder.class);
                    }
                }
            }
            case BIGINT: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(BigIntHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableBigIntHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedBigIntHolder.class);
                    }
                }
            }
            case UINT8: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(UInt8Holder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableUInt8Holder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedUInt8Holder.class);
                    }
                }
            }
            case FLOAT8: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(Float8Holder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableFloat8Holder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedFloat8Holder.class);
                    }
                }
            }
            case DATE: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(DateHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableDateHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedDateHolder.class);
                    }
                }
            }
            case TIMESTAMP: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(TimeStampHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableTimeStampHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedTimeStampHolder.class);
                    }
                }
            }
            case DECIMAL18: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(Decimal18Holder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableDecimal18Holder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedDecimal18Holder.class);
                    }
                }
            }
            case INTERVALDAY: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(IntervalDayHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableIntervalDayHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedIntervalDayHolder.class);
                    }
                }
            }
            case INTERVAL: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(IntervalHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableIntervalHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedIntervalHolder.class);
                    }
                }
            }
            case DECIMAL28DENSE: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(Decimal28DenseHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableDecimal28DenseHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedDecimal28DenseHolder.class);
                    }
                }
            }
            case DECIMAL38DENSE: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(Decimal38DenseHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableDecimal38DenseHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedDecimal38DenseHolder.class);
                    }
                }
            }
            case DECIMAL38SPARSE: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(Decimal38SparseHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableDecimal38SparseHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedDecimal38SparseHolder.class);
                    }
                }
            }
            case DECIMAL28SPARSE: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(Decimal28SparseHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableDecimal28SparseHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedDecimal28SparseHolder.class);
                    }
                }
            }
            case VARBINARY: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(VarBinaryHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableVarBinaryHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedVarBinaryHolder.class);
                    }
                }
            }
            case VARCHAR: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(VarCharHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableVarCharHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedVarCharHolder.class);
                    }
                }
            }
            case VAR16CHAR: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(Var16CharHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableVar16CharHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedVar16CharHolder.class);
                    }
                }
            }
            case VARDECIMAL: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(VarDecimalHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableVarDecimalHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedVarDecimalHolder.class);
                    }
                }
            }
            case BIT: {
                switch (mode) {
                    case REQUIRED: {
                        return model._ref(BitHolder.class);
                    }
                    case OPTIONAL: {
                        return model._ref(NullableBitHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedBitHolder.class);
                    }
                }
            }
            case GENERIC_OBJECT: {
                return model._ref(ObjectHolder.class);
            }
            case NULL: {
                return model._ref(UntypedNullHolder.class);
            }
        }
        throw new UnsupportedOperationException(TypeHelper.buildErrorMessage("get holder type", type, mode));
    }

    public static JType getComplexHolderType(JCodeModel model, TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        switch (type) {
            case DICT: {
                switch (mode) {
                    case REQUIRED: 
                    case OPTIONAL: {
                        return model._ref(DictHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedDictHolder.class);
                    }
                }
            }
            case MAP: {
                switch (mode) {
                    case REQUIRED: 
                    case OPTIONAL: {
                        return model._ref(MapHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedMapHolder.class);
                    }
                }
            }
            case LIST: {
                switch (mode) {
                    case REQUIRED: 
                    case OPTIONAL: {
                        return model._ref(ListHolder.class);
                    }
                    case REPEATED: {
                        return model._ref(RepeatedListHolder.class);
                    }
                }
            }
        }
        throw new IllegalArgumentException("Complex type expected. Found: " + type);
    }
}

