/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCast;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.DrillSimpleFuncHolder;
import org.apache.drill.exec.expr.fn.FunctionAttributes;
import org.apache.drill.exec.expr.fn.FunctionInitializer;
import org.apache.drill.exec.physical.impl.project.ProjectRecordBatch;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.record.VectorAccessibleComplexWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class DrillComplexWriterFuncHolder
extends DrillSimpleFuncHolder {
    public DrillComplexWriterFuncHolder(FunctionAttributes functionAttributes, FunctionInitializer initializer) {
        super(functionAttributes, initializer);
    }

    @Override
    public boolean isComplexWriterFuncHolder() {
        return true;
    }

    @Override
    protected ClassGenerator.HoldingContainer generateEvalBody(ClassGenerator<?> classGenerator, ClassGenerator.HoldingContainer[] inputVariables, String body, JVar[] workspaceJVars, FunctionHolderExpression holderExpr) {
        JBlock sub;
        FieldReference fieldReference = holderExpr.getFieldReference();
        classGenerator.getEvalBlock().directStatement(String.format("//---- start of eval portion of %s function. ----//", this.getRegisteredNames()[0]));
        JBlock topSub = sub = new JBlock(true, true);
        JVar rsLoader = null;
        JVar complexWriter = null;
        JInvocation container = null;
        for (JVar workspaceJVar : workspaceJVars) {
            if (!"ResultSetLoader".equals(workspaceJVar.type().name())) continue;
            rsLoader = workspaceJVar;
        }
        if (rsLoader == null) {
            complexWriter = classGenerator.declareClassField("complexWriter", classGenerator.getModel()._ref(BaseWriter.ComplexWriter.class));
            container = classGenerator.getMappingSet().getOutgoing().invoke("getOutgoingContainer");
        }
        String refName = fieldReference == null ? "col" : fieldReference.getRootSegment().getPath();
        JClass cwClass = classGenerator.getModel().ref(VectorAccessibleComplexWriter.class);
        if (rsLoader == null) {
            classGenerator.getSetupBlock().assign((JAssignmentTarget)complexWriter, (JExpression)cwClass.staticInvoke("getWriter").arg(refName).arg((JExpression)container));
        }
        JClass projBatchClass = classGenerator.getModel().ref(ProjectRecordBatch.class);
        JCast projBatch = JExpr.cast((JType)projBatchClass, (JExpression)classGenerator.getMappingSet().getOutgoing());
        if (rsLoader == null) {
            classGenerator.getSetupBlock().add((JStatement)projBatch.invoke("addComplexWriter").arg((JExpression)complexWriter));
            classGenerator.getEvalBlock().add((JStatement)complexWriter.invoke("setPosition").arg((JExpression)classGenerator.getMappingSet().getValueWriteIndex()));
            sub.decl(classGenerator.getModel()._ref(BaseWriter.ComplexWriter.class), this.getReturnValue().getName(), (JExpression)complexWriter);
        } else {
            classGenerator.getSetupBlock().add((JStatement)projBatch.invoke("addLoader").arg((JExpression)rsLoader));
            sub.decl(classGenerator.getModel()._ref(ResultSetLoader.class), this.getReturnValue().getName(), (JExpression)rsLoader);
        }
        classGenerator.getEvalBlock().add((JStatement)topSub);
        this.addProtectedBlock(classGenerator, sub, body, inputVariables, workspaceJVars, false);
        classGenerator.getEvalBlock().directStatement(String.format("//---- end of eval portion of %s function. ----//", this.getRegisteredNames()[0]));
        return null;
    }

    @Override
    protected void checkNullHandling(FunctionTemplate.NullHandling nullHandling) {
        Preconditions.checkArgument(nullHandling == FunctionTemplate.NullHandling.INTERNAL, "Function with @Output of type 'org.apache.drill.exec.vector.complex.writer.BaseWriter.ComplexWriter' is required to handle null input(s) on its own.");
    }
}

