/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.sun.codemodel.JArrayCompRef;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Arrays;
import java.util.List;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.compile.bytecode.ScalarReplacementTypes;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.DrillFuncHolderExpr;
import org.apache.drill.exec.expr.EvaluationVisitor;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.AbstractFuncHolder;
import org.apache.drill.exec.expr.fn.FunctionAttributes;
import org.apache.drill.exec.expr.fn.FunctionInitializer;
import org.apache.drill.exec.expr.fn.ValueReference;
import org.apache.drill.exec.expr.fn.WorkspaceReference;
import org.apache.drill.exec.expr.fn.output.OutputWidthCalculator;
import org.apache.drill.exec.expr.holders.UnionHolder;
import org.apache.drill.exec.expr.holders.ValueHolder;
import org.apache.drill.exec.ops.UdfUtilities;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DrillFuncHolder
extends AbstractFuncHolder {
    private static final Logger logger = LoggerFactory.getLogger(DrillFuncHolder.class);
    private final FunctionAttributes attributes;
    private final FunctionInitializer initializer;

    public DrillFuncHolder(FunctionAttributes attributes, FunctionInitializer initializer) {
        this.attributes = attributes;
        this.initializer = initializer;
        this.checkNullHandling(attributes.getNullHandling());
    }

    protected void checkNullHandling(FunctionTemplate.NullHandling nullHandling) {
    }

    protected String meth(String methodName) {
        return this.meth(methodName, true);
    }

    protected String meth(String methodName, boolean required) {
        String method = this.initializer.getMethod(methodName);
        if (method == null) {
            if (!required) {
                return "";
            }
            throw UserException.functionError().message("Failure while trying use function. No body found for required method %s.", methodName).addContext("FunctionClass", this.initializer.getClassName()).build(logger);
        }
        return method;
    }

    @Override
    public JVar[] renderStart(ClassGenerator<?> g, ClassGenerator.HoldingContainer[] inputVariables, FieldReference fieldReference) {
        return this.declareWorkspaceVariables(g);
    }

    @Override
    public FunctionHolderExpression getExpr(String name, List<LogicalExpression> args, ExpressionPosition pos) {
        return new DrillFuncHolderExpr(name, this, args, pos);
    }

    public boolean isAggregating() {
        return false;
    }

    public boolean isDeterministic() {
        return this.attributes.isDeterministic();
    }

    public boolean isNiladic() {
        return this.attributes.isNiladic();
    }

    public boolean isInternal() {
        return this.attributes.isInternal();
    }

    public boolean isVarArg() {
        return this.attributes.isVarArg();
    }

    public String getInputParameters() {
        StringBuilder builder = new StringBuilder();
        for (ValueReference ref : this.attributes.getParameters()) {
            TypeProtos.MajorType type = ref.getType();
            builder.append(",");
            builder.append(type.getMinorType().toString());
            builder.append("-");
            builder.append(type.getMode().toString());
        }
        if (this.isVarArg() && this.getParamCount() > 0) {
            builder.append("...");
        }
        return builder.length() == 0 ? builder.toString() : builder.substring(1);
    }

    public ClassLoader getClassLoader() {
        return this.initializer.getClassLoader();
    }

    protected JVar[] declareWorkspaceVariables(ClassGenerator<?> g) {
        JVar[] workspaceJVars = new JVar[this.attributes.getWorkspaceVars().length];
        for (int i = 0; i < this.attributes.getWorkspaceVars().length; ++i) {
            WorkspaceReference ref = this.attributes.getWorkspaceVars()[i];
            JType jtype = g.getModel()._ref(ref.getType());
            workspaceJVars[i] = g.declareClassField("work", jtype);
            if (ScalarReplacementTypes.CLASSES.contains(ref.getType())) {
                JBlock b = g.getBlock("__DRILL_INIT__");
                b.assign((JAssignmentTarget)workspaceJVars[i], (JExpression)JExpr._new((JType)jtype));
            }
            if (!ref.isInject()) continue;
            this.assignInjectableValue(g, workspaceJVars[i], ref);
        }
        return workspaceJVars;
    }

    protected void assignInjectableValue(ClassGenerator<?> g, JVar variable, WorkspaceReference ref) {
        if (UdfUtilities.INJECTABLE_GETTER_METHODS.get(ref.getType()) == null) {
            throw new DrillRuntimeException("Invalid injectable type requested in UDF: " + ref.getType().getSimpleName());
        }
        g.getBlock(ClassGenerator.BlockType.SETUP).assign((JAssignmentTarget)variable, (JExpression)g.getMappingSet().getIncoming().invoke("getContext").invoke(UdfUtilities.INJECTABLE_GETTER_METHODS.get(ref.getType())));
    }

    protected void generateBody(ClassGenerator<?> g, ClassGenerator.BlockType bt, String body, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars, boolean workspaceOnly) {
        if (Strings.isNullOrEmpty(body) || body.trim().isEmpty()) {
            return;
        }
        g.getBlock(bt).directStatement(String.format("/** start %s for function %s **/ ", bt.name(), this.attributes.getRegisteredNames()[0]));
        JBlock sub = new JBlock(true, true);
        this.addProtectedBlock(g, sub, body, inputVariables, workspaceJVars, workspaceOnly);
        g.getBlock(bt).add((JStatement)sub);
        g.getBlock(bt).directStatement(String.format("/** end %s for function %s **/ ", bt.name(), this.attributes.getRegisteredNames()[0]));
    }

    protected void addProtectedBlock(ClassGenerator<?> g, JBlock sub, String body, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars, boolean workspaceOnly) {
        int i;
        if (inputVariables != null) {
            if (this.isVarArg()) {
                this.declareVarArgArray(g.getModel(), sub, inputVariables);
            }
            for (int i2 = 0; i2 < inputVariables.length; ++i2) {
                if (workspaceOnly && !inputVariables[i2].isConstant()) continue;
                this.declareInputVariable(g.getModel(), sub, inputVariables[i2], i2);
            }
        }
        JVar[] internalVars = new JVar[workspaceJVars.length];
        for (i = 0; i < workspaceJVars.length; ++i) {
            internalVars[i] = sub.decl(g.getModel()._ref(this.attributes.getWorkspaceVars()[i].getType()), this.attributes.getWorkspaceVars()[i].getName(), (JExpression)workspaceJVars[i]);
        }
        Preconditions.checkNotNull(body);
        sub.directStatement(body);
        for (i = 0; i < workspaceJVars.length; ++i) {
            sub.assign((JAssignmentTarget)workspaceJVars[i], (JExpression)internalVars[i]);
        }
    }

    protected void declareVarArgArray(JCodeModel model, JBlock jBlock, ClassGenerator.HoldingContainer[] inputVariables) {
        ValueReference parameter = this.getAttributeParameter(this.getParamCount() - 1);
        JType defaultType = inputVariables.length >= this.getParamCount() ? inputVariables[inputVariables.length - 1].getHolder().type() : (parameter.getType().getMinorType() == TypeProtos.MinorType.LATE ? model._ref(ValueHolder.class) : TypeHelper.getHolderType(model, parameter.getType().getMinorType(), parameter.getType().getMode()));
        JType paramClass = this.getParamClass(model, parameter, defaultType);
        jBlock.decl((JType)paramClass.array(), parameter.getName(), (JExpression)JExpr.newArray((JType)paramClass, (int)(inputVariables.length - this.getParamCount() + 1)));
    }

    protected void declareInputVariable(JCodeModel model, JBlock jBlock, ClassGenerator.HoldingContainer inputVariable, int currentIndex) {
        ValueReference parameter = this.getAttributeParameter(currentIndex);
        if (!inputVariable.isReader() && parameter.isFieldReader()) {
            this.convertHolderToReader(model, jBlock, inputVariable, currentIndex, parameter);
        } else if (inputVariable.isReader() && !parameter.isFieldReader()) {
            this.convertReaderToHolder(model, jBlock, inputVariable, currentIndex, parameter);
        } else {
            this.assignParamDirectly(jBlock, inputVariable, currentIndex, parameter);
        }
    }

    private void convertHolderToReader(JCodeModel model, JBlock jBlock, ClassGenerator.HoldingContainer inputVariable, int currentIndex, ValueReference parameter) {
        JVar inputHolder = inputVariable.getHolder();
        TypeProtos.MajorType inputSqlType = inputVariable.getMajorType();
        JType paramClass = model._ref(FieldReader.class);
        if (Types.isComplex(inputSqlType)) {
            throw new UnsupportedOperationException(String.format("Cannot convert values of type %s from a holder to a reader", inputSqlType.getMinorType().name()));
        }
        if (Types.isUnion(inputSqlType)) {
            EvaluationVisitor.VectorVariableHolder vvHolder = (EvaluationVisitor.VectorVariableHolder)inputVariable;
            JVar readerVar = vvHolder.generateUnionReader();
            this.declare(jBlock, parameter, paramClass, (JExpression)readerVar, currentIndex);
        } else {
            JType singularReaderClass = model._ref(TypeHelper.getHolderReaderImpl(inputSqlType.getMinorType(), inputSqlType.getMode()));
            JInvocation reader = JExpr._new((JType)singularReaderClass).arg((JExpression)inputHolder);
            this.declare(jBlock, parameter, paramClass, (JExpression)reader, currentIndex);
        }
    }

    private void convertReaderToHolder(JCodeModel model, JBlock jBlock, ClassGenerator.HoldingContainer inputVariable, int currentIndex, ValueReference parameter) {
        JVar inputHolder = inputVariable.getHolder();
        TypeProtos.MajorType inputSqlType = inputVariable.getMajorType();
        if (Types.isComplex(parameter.getType())) {
            JType holderClass = this.getParamClass(model, parameter, inputHolder.type());
            JAssignmentTarget holderVar = this.declare(jBlock, parameter, holderClass, (JExpression)JExpr._new((JType)holderClass), currentIndex);
            jBlock.assign((JAssignmentTarget)holderVar.ref("reader"), (JExpression)inputHolder);
        } else if (Types.isUnion(inputSqlType)) {
            JType holderClass = model._ref(UnionHolder.class);
            JVar paramVar = jBlock.decl(holderClass, parameter.getName(), (JExpression)JExpr._new((JType)holderClass));
            JInvocation readCall = inputHolder.invoke("read");
            readCall.arg((JExpression)paramVar);
            jBlock.add((JStatement)readCall);
        } else {
            throw new UnsupportedOperationException(String.format("Cannot convert values of type %s from a reader to a holder", inputSqlType.getMinorType().name()));
        }
    }

    private void assignParamDirectly(JBlock jBlock, ClassGenerator.HoldingContainer inputVariable, int currentIndex, ValueReference parameter) {
        JVar inputHolder = inputVariable.getHolder();
        this.declare(jBlock, parameter, inputHolder.type(), (JExpression)inputHolder, currentIndex);
    }

    private JType getParamClass(JCodeModel model, ValueReference parameter, JType defaultType) {
        if (parameter.isFieldReader()) {
            return model._ref(FieldReader.class);
        }
        if (Types.isComplex(parameter.getType())) {
            TypeProtos.MajorType type = parameter.getType();
            return TypeHelper.getComplexHolderType(model, type.getMinorType(), type.getMode());
        }
        return defaultType;
    }

    protected JAssignmentTarget declare(JBlock jBlock, ValueReference parameter, JType paramClass, JExpression paramExpression, int currentIndex) {
        if (parameter.isVarArg()) {
            JArrayCompRef arrayComponent = JExpr.ref((String)parameter.getName()).component(JExpr.lit((int)(currentIndex - this.getParamCount() + 1)));
            jBlock.assign((JAssignmentTarget)arrayComponent, paramExpression);
            return arrayComponent;
        }
        return jBlock.decl(paramClass, parameter.getName(), paramExpression);
    }

    public boolean matches(TypeProtos.MajorType returnType, List<TypeProtos.MajorType> argTypes) {
        if (!this.softCompare(returnType, this.attributes.getReturnValue().getType())) {
            return false;
        }
        if (argTypes.size() != this.attributes.getParameters().length) {
            return false;
        }
        for (int i = 0; i < this.attributes.getParameters().length; ++i) {
            if (this.softCompare(this.getAttributeParameter(i).getType(), argTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public TypeProtos.MajorType getParamMajorType(int i) {
        return this.getAttributeParameter(i).getType();
    }

    @Override
    public int getParamCount() {
        return this.attributes.getParameters().length;
    }

    public boolean isConstant(int i) {
        return this.getAttributeParameter(i).isConstant();
    }

    public ValueReference getAttributeParameter(int i) {
        if (i >= this.getParamCount() && this.attributes.isVarArg()) {
            return this.attributes.getParameters()[this.getParamCount() - 1];
        }
        return this.attributes.getParameters()[i];
    }

    public boolean isFieldReader(int i) {
        return this.getAttributeParameter(i).isFieldReader();
    }

    public TypeProtos.MajorType getReturnType(List<LogicalExpression> logicalExpressions) {
        return this.attributes.getReturnType().getType(logicalExpressions, this.attributes);
    }

    public OutputWidthCalculator getOutputWidthCalculator() {
        return this.attributes.getOutputWidthCalculatorType().getOutputWidthCalculator();
    }

    public int variableOutputSizeEstimate() {
        return this.attributes.variableOutputSizeEstimate();
    }

    public FunctionTemplate.NullHandling getNullHandling() {
        return this.attributes.getNullHandling();
    }

    private boolean softCompare(TypeProtos.MajorType a, TypeProtos.MajorType b) {
        return Types.softEquals(a, b, this.getNullHandling() == FunctionTemplate.NullHandling.NULL_IF_NULL);
    }

    public String[] getRegisteredNames() {
        return this.attributes.getRegisteredNames();
    }

    public int getCostCategory() {
        return this.attributes.getCostCategory().getValue();
    }

    public ValueReference[] getParameters() {
        return this.attributes.getParameters();
    }

    public boolean checkPrecisionRange() {
        return this.attributes.checkPrecisionRange();
    }

    public TypeProtos.MajorType getReturnType() {
        return this.attributes.getReturnValue().getType();
    }

    public ValueReference getReturnValue() {
        return this.attributes.getReturnValue();
    }

    public WorkspaceReference[] getWorkspaceVars() {
        return this.attributes.getWorkspaceVars();
    }

    public String toString() {
        int maxLen = 10;
        return this.getClass().getSimpleName() + " [functionNames=" + Arrays.toString(this.attributes.getRegisteredNames()) + ", returnType=" + Types.toString(this.attributes.getReturnValue().getType()) + ", nullHandling=" + (Object)((Object)this.attributes.getNullHandling()) + ", parameters=" + (this.attributes.getParameters() != null ? Arrays.asList(this.attributes.getParameters()).subList(0, Math.min(this.attributes.getParameters().length, 10)) : null) + "]";
    }
}

