/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.List;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.FunctionAttributes;
import org.apache.drill.exec.expr.fn.FunctionInitializer;
import org.apache.drill.exec.vector.ValueHolderHelper;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class DrillSimpleFuncHolder
extends DrillFuncHolder {
    private final String drillFuncClass;
    private final ClassLoader classLoader;

    public DrillSimpleFuncHolder(FunctionAttributes functionAttributes, FunctionInitializer initializer) {
        super(functionAttributes, initializer);
        this.drillFuncClass = Preconditions.checkNotNull(initializer.getClassName());
        this.classLoader = Preconditions.checkNotNull(initializer.getClassLoader());
    }

    private String setupBody() {
        return this.meth("setup", false);
    }

    private String evalBody() {
        return this.meth("eval");
    }

    private String resetBody() {
        return this.meth("reset", false);
    }

    private String cleanupBody() {
        return this.meth("cleanup", false);
    }

    @Override
    public boolean isNested() {
        return false;
    }

    public DrillSimpleFunc createInterpreter() throws Exception {
        return (DrillSimpleFunc)Class.forName(this.drillFuncClass, true, this.classLoader).newInstance();
    }

    @Override
    public ClassGenerator.HoldingContainer renderEnd(ClassGenerator<?> classGenerator, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars, FunctionHolderExpression holderExpr) {
        for (int i = 0; i < inputVariables.length; ++i) {
            if (!this.getAttributeParameter(i).isConstant() || inputVariables[i].isConstant()) continue;
            throw new DrillRuntimeException(String.format("The argument '%s' of Function '%s' has to be constant!", this.getAttributeParameter(i).getName(), this.getRegisteredNames()[0]));
        }
        this.generateBody(classGenerator, ClassGenerator.BlockType.SETUP, this.setupBody(), inputVariables, workspaceJVars, true);
        ClassGenerator.HoldingContainer c = this.generateEvalBody(classGenerator, inputVariables, this.evalBody(), workspaceJVars, holderExpr);
        this.generateBody(classGenerator, ClassGenerator.BlockType.RESET, this.resetBody(), null, workspaceJVars, false);
        this.generateBody(classGenerator, ClassGenerator.BlockType.CLEANUP, this.cleanupBody(), null, workspaceJVars, false);
        return c;
    }

    protected ClassGenerator.HoldingContainer generateEvalBody(ClassGenerator<?> g, ClassGenerator.HoldingContainer[] inputVariables, String body, JVar[] workspaceJVars, FunctionHolderExpression holderExpr) {
        JBlock sub;
        g.getEvalBlock().directStatement(String.format("//---- start of eval portion of %s function. ----//", this.getRegisteredNames()[0]));
        JBlock topSub = sub = new JBlock(true, true);
        ClassGenerator.HoldingContainer out = null;
        TypeProtos.MajorType returnValueType = this.getReturnType();
        if (this.getNullHandling() == FunctionTemplate.NullHandling.NULL_IF_NULL) {
            Object e = null;
            for (ClassGenerator.HoldingContainer v : inputVariables) {
                if (!v.isOptional()) continue;
                Object isNullExpr = v.isReader() ? JOp.cond((JExpression)v.getHolder().invoke("isSet"), (JExpression)JExpr.lit((int)1), (JExpression)JExpr.lit((int)0)) : v.getIsSet();
                e = e == null ? isNullExpr : e.mul((JExpression)isNullExpr);
            }
            if (e != null) {
                returnValueType = this.getReturnType().toBuilder().setMode(TypeProtos.DataMode.OPTIONAL).build();
                out = g.declare(returnValueType);
                e = e.eq(JExpr.lit((int)0));
                JConditional jc = sub._if((JExpression)e);
                jc._then().assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)0));
                sub = jc._else();
            } else if (holderExpr.getMajorType().getMode() == TypeProtos.DataMode.OPTIONAL) {
                returnValueType = this.getReturnType().toBuilder().setMode(TypeProtos.DataMode.OPTIONAL).build();
            }
        }
        if (out == null) {
            out = g.declare(returnValueType);
        }
        g.getEvalBlock().add((JStatement)topSub);
        JVar internalOutput = sub.decl(8, g.getHolderType(returnValueType), this.getReturnValue().getName(), (JExpression)JExpr._new((JType)g.getHolderType(returnValueType)));
        this.addProtectedBlock(g, sub, body, inputVariables, workspaceJVars, false);
        List<String> holderFields = ValueHolderHelper.getHolderParams(returnValueType);
        for (String holderField : holderFields) {
            sub.assign((JAssignmentTarget)out.f(holderField), (JExpression)internalOutput.ref(holderField));
        }
        if (sub != topSub) {
            sub.assign((JAssignmentTarget)out.f("isSet"), JExpr.lit((int)1));
        }
        g.getEvalBlock().directStatement(String.format("//---- end of eval portion of %s function. ----//", this.getRegisteredNames()[0]));
        return out;
    }
}

