/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

public class ExceptionFunction {
    public static final String EXCEPTION_FUNCTION_NAME = "__throwException";

    public static void throwException(String message) {
        throw new DrillRuntimeException(message);
    }

    @FunctionTemplate(name="__throwException", isRandom=true, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ThrowException
    implements DrillSimpleFunc {
        @Param
        VarCharHolder message;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            String msg = StringFunctionHelpers.toStringFromUTF8(this.message.start, this.message.end, this.message.buffer);
            ExceptionFunction.throwException(msg);
        }
    }
}

