/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.ValueReference;
import org.apache.drill.exec.expr.fn.WorkspaceReference;

public class FunctionAttributes {
    private final FunctionTemplate template;
    private final String[] registeredNames;
    private final ValueReference[] parameters;
    private final ValueReference returnValue;
    private final WorkspaceReference[] workspaceVars;

    public FunctionAttributes(FunctionTemplate template, ValueReference[] parameters, ValueReference returnValue, WorkspaceReference[] workspaceVars) {
        String[] stringArray;
        this.template = template;
        if (template.name().isEmpty()) {
            stringArray = template.names();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = template.name();
        }
        this.registeredNames = stringArray;
        this.parameters = parameters;
        this.returnValue = returnValue;
        this.workspaceVars = workspaceVars;
    }

    public FunctionTemplate.FunctionScope getScope() {
        return this.template.scope();
    }

    public FunctionTemplate.ReturnType getReturnType() {
        return this.template.returnType();
    }

    public FunctionTemplate.OutputWidthCalculatorType getOutputWidthCalculatorType() {
        return this.template.outputWidthCalculatorType();
    }

    public int variableOutputSizeEstimate() {
        return this.template.outputSizeEstimate();
    }

    public FunctionTemplate.NullHandling getNullHandling() {
        return this.template.nulls();
    }

    public boolean isBinaryCommutative() {
        return this.template.isBinaryCommutative();
    }

    @Deprecated
    public boolean isRandom() {
        return this.template.isRandom();
    }

    public boolean isDeterministic() {
        return !this.template.isRandom();
    }

    public String[] getRegisteredNames() {
        return this.registeredNames;
    }

    public ValueReference[] getParameters() {
        return this.parameters;
    }

    public ValueReference getReturnValue() {
        return this.returnValue;
    }

    public WorkspaceReference[] getWorkspaceVars() {
        return this.workspaceVars;
    }

    public FunctionTemplate.FunctionCostCategory getCostCategory() {
        return this.template.costCategory();
    }

    public boolean isNiladic() {
        return this.template.isNiladic();
    }

    public boolean isVarArg() {
        return this.template.isVarArg();
    }

    public boolean isInternal() {
        return this.template.isInternal();
    }

    public boolean checkPrecisionRange() {
        return this.template.checkPrecisionRange();
    }
}

