/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.scanner.persistence.AnnotatedClassDescriptor;
import org.apache.drill.common.scanner.persistence.FieldDescriptor;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.DrillFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.DrillAggFuncHolder;
import org.apache.drill.exec.expr.fn.DrillComplexWriterAggFuncHolder;
import org.apache.drill.exec.expr.fn.DrillComplexWriterFuncHolder;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.DrillSimpleFuncHolder;
import org.apache.drill.exec.expr.fn.FunctionAttributes;
import org.apache.drill.exec.expr.fn.FunctionInitializer;
import org.apache.drill.exec.expr.fn.ValueReference;
import org.apache.drill.exec.expr.fn.WorkspaceReference;
import org.apache.drill.exec.expr.holders.ValueHolder;
import org.apache.drill.exec.ops.UdfUtilities;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionConverter {
    private static final Logger logger = LoggerFactory.getLogger(FunctionConverter.class);

    public DrillFuncHolder getHolder(AnnotatedClassDescriptor func, ClassLoader classLoader) {
        FunctionTemplate template = func.getAnnotationProxy(FunctionTemplate.class);
        if (template == null) {
            return this.failure("Class does not declare FunctionTemplate annotation.", func);
        }
        String name = template.name();
        List<String> names = Arrays.asList(template.names());
        if (name.isEmpty() && names.isEmpty()) {
            return this.failure("Must define 'name' or 'names'", func);
        }
        if (!name.isEmpty() && !names.isEmpty()) {
            return this.failure("Must use only one annotations 'name' or 'names', not both", func);
        }
        ArrayList<ValueReference> params = Lists.newArrayList();
        ArrayList<WorkspaceReference> workspaceFields = Lists.newArrayList();
        ValueReference outputField = null;
        int varArgsCount = 0;
        for (FieldDescriptor field : func.getFields()) {
            boolean isInject;
            Param param = field.getAnnotationProxy(Param.class);
            Output output = field.getAnnotationProxy(Output.class);
            Workspace workspace = field.getAnnotationProxy(Workspace.class);
            Inject inject = field.getAnnotationProxy(Inject.class);
            Annotation[] annotations = new Annotation[]{param, output, workspace, inject};
            int annotationCount = 0;
            for (Annotation annotationDescriptor : annotations) {
                if (annotationDescriptor == null) continue;
                ++annotationCount;
            }
            if (annotationCount == 0) {
                return FunctionConverter.failure("The field must be either a @Param, @Output, @Inject or @Workspace field.", func, field);
            }
            if (annotationCount > 1) {
                return FunctionConverter.failure("The field must be only one of @Param, @Output, @Inject or @Workspace. It currently has more than one of these annotations.", func, field);
            }
            Class<?> fieldClass = field.getFieldClass();
            if (param != null || output != null) {
                TypeProtos.MajorType type;
                if (Object[].class.isAssignableFrom(fieldClass)) {
                    fieldClass = fieldClass.getComponentType();
                    ++varArgsCount;
                } else if (varArgsCount > 0 && param != null) {
                    return FunctionConverter.failure("Vararg should be the last argument in the function.", func, field);
                }
                if (varArgsCount > 1) {
                    return FunctionConverter.failure("Function should contain single vararg argument", func, field);
                }
                if (param != null && FieldReader.class.isAssignableFrom(fieldClass)) {
                    ValueReference fieldReaderRef = ValueReference.createFieldReaderRef(field.getName());
                    fieldReaderRef.setVarArg(varArgsCount > 0);
                    params.add(fieldReaderRef);
                    continue;
                }
                if (output != null && BaseWriter.ComplexWriter.class.isAssignableFrom(fieldClass)) {
                    if (outputField != null) {
                        return FunctionConverter.failure("You've declared more than one @Output field.\nYou must declare one and only @Output field per Function class.", func, field);
                    }
                    outputField = ValueReference.createComplexWriterRef(field.getName());
                    continue;
                }
                if (!ValueHolder.class.isAssignableFrom(fieldClass)) {
                    return FunctionConverter.failure(String.format("The field doesn't holds value of type %s which does not implement the ValueHolder or ComplexWriter interfaces.\nAll fields of type @Param or @Output must extend this interface.", fieldClass), func, field);
                }
                try {
                    type = this.getStaticFieldValue("TYPE", fieldClass, TypeProtos.MajorType.class);
                }
                catch (Exception e) {
                    return FunctionConverter.failure("Failure while trying to access the ValueHolder's TYPE static variable.  All ValueHolders must contain a static TYPE variable that defines their MajorType.", e, func, field);
                }
                ValueReference p = new ValueReference(type, field.getName());
                if (param != null) {
                    p.setConstant(param.constant());
                    p.setVarArg(varArgsCount > 0);
                    params.add(p);
                    continue;
                }
                if (outputField != null) {
                    return FunctionConverter.failure("You've declared more than one @Output field.  You must declare one and only @Output field per Function class.", func, field);
                }
                outputField = p;
                continue;
            }
            boolean bl = isInject = inject != null;
            if (isInject && UdfUtilities.INJECTABLE_GETTER_METHODS.get(fieldClass) == null) {
                return FunctionConverter.failure(String.format("A %s cannot be injected into a %s, available injectable classes are: %s.", fieldClass, DrillFunc.class.getSimpleName(), Joiner.on(",").join(UdfUtilities.INJECTABLE_GETTER_METHODS.keySet())), func, field);
            }
            WorkspaceReference wsReference = new WorkspaceReference(fieldClass, field.getName(), isInject);
            if (!isInject && template.scope() == FunctionTemplate.FunctionScope.POINT_AGGREGATE && !ValueHolder.class.isAssignableFrom(fieldClass)) {
                return FunctionConverter.failure(String.format("Aggregate function '%s' workspace variable '%s' is of type '%s'. Please change it to Holder type.", func.getClassName(), field.getName(), fieldClass), func, field);
            }
            if (ValueHolder.class.isAssignableFrom(fieldClass)) {
                TypeProtos.MajorType majorType;
                try {
                    majorType = this.getStaticFieldValue("TYPE", fieldClass, TypeProtos.MajorType.class);
                }
                catch (Exception e) {
                    return FunctionConverter.failure("Failure while trying to access the ValueHolder's TYPE static variable.  All ValueHolders must contain a static TYPE variable that defines their MajorType.", e, func, field);
                }
                wsReference.setMajorType(majorType);
            }
            workspaceFields.add(wsReference);
        }
        if (outputField == null) {
            return this.failure("This function declares zero output fields.  A function must declare one output field.", func);
        }
        FunctionInitializer initializer = new FunctionInitializer(func.getClassName(), classLoader);
        try {
            ValueReference[] ps = params.toArray(new ValueReference[0]);
            WorkspaceReference[] works = workspaceFields.toArray(new WorkspaceReference[0]);
            FunctionAttributes functionAttributes = new FunctionAttributes(template, ps, outputField, works);
            switch (template.scope()) {
                case POINT_AGGREGATE: {
                    return outputField.isComplexWriter() ? new DrillComplexWriterAggFuncHolder(functionAttributes, initializer) : new DrillAggFuncHolder(functionAttributes, initializer);
                }
                case SIMPLE: {
                    return outputField.isComplexWriter() ? new DrillComplexWriterFuncHolder(functionAttributes, initializer) : new DrillSimpleFuncHolder(functionAttributes, initializer);
                }
            }
            return this.failure("Unsupported Function Type.", func);
        }
        catch (AbstractMethodError | Exception | NoSuchFieldError ex) {
            return this.failure("Failure while creating function holder.", ex, func);
        }
    }

    private <T> T getStaticFieldValue(String fieldName, Class<?> valueType, Class<T> c) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field f = valueType.getDeclaredField(fieldName);
        Object val = f.get(null);
        return (T)val;
    }

    private static DrillFuncHolder failure(String message, Throwable t, AnnotatedClassDescriptor func, FieldDescriptor field) {
        return FunctionConverter.fieldFailure(message, t, func.getClassName(), field.getName());
    }

    private static DrillFuncHolder failure(String message, AnnotatedClassDescriptor func, FieldDescriptor field) {
        return FunctionConverter.fieldFailure(message, null, func.getClassName(), field.getName());
    }

    private DrillFuncHolder failure(String message, AnnotatedClassDescriptor func) {
        return FunctionConverter.classFailure(message, null, func.getClassName());
    }

    private DrillFuncHolder failure(String message, Throwable t, AnnotatedClassDescriptor func) {
        return FunctionConverter.classFailure(message, t, func.getClassName());
    }

    private static DrillFuncHolder classFailure(String message, Throwable t, String funcClassName) {
        return FunctionConverter.failure(String.format("Failure loading function class [%s]. Message: %s", funcClassName, message), t);
    }

    private static DrillFuncHolder fieldFailure(String message, Throwable t, String funcClassName, String fieldName) {
        return FunctionConverter.failure(String.format("Failure loading function class %s, field %s. Message: %s", funcClassName, fieldName, message), t);
    }

    private static DrillFuncHolder failure(String message, Throwable t) {
        if (t == null) {
            t = new DrillRuntimeException(message);
        }
        logger.warn(message, t);
        return null;
    }
}

