/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import java.util.ArrayList;
import org.apache.drill.common.FunctionNames;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.IfExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.HoldingContainerExpression;
import org.apache.drill.exec.expr.fn.FunctionLookupContext;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class FunctionGenerationHelper
implements FunctionNames {
    public static LogicalExpression getOrderingComparator(boolean null_high, ClassGenerator.HoldingContainer left, ClassGenerator.HoldingContainer right, FunctionLookupContext functionLookupContext) {
        String comparator_name;
        String string = comparator_name = null_high ? "compare_to_nulls_high" : "compare_to_nulls_low";
        if (!FunctionGenerationHelper.isComparableType(left.getMajorType()) || !FunctionGenerationHelper.isComparableType(right.getMajorType())) {
            throw new UnsupportedOperationException(FunctionGenerationHelper.formatCanNotCompareMsg(left.getMajorType(), right.getMajorType()));
        }
        LogicalExpression comparisonFunctionExpression = FunctionGenerationHelper.getFunctionExpression(comparator_name, left, right);
        ErrorCollectorImpl collector = new ErrorCollectorImpl();
        if (!FunctionGenerationHelper.isUnionType(left.getMajorType()) && !FunctionGenerationHelper.isUnionType(right.getMajorType())) {
            return ExpressionTreeMaterializer.materialize(comparisonFunctionExpression, null, collector, functionLookupContext);
        }
        LogicalExpression typeComparisonFunctionExpression = FunctionGenerationHelper.getTypeComparisonFunction(comparisonFunctionExpression, left, right);
        return ExpressionTreeMaterializer.materialize(typeComparisonFunctionExpression, null, collector, functionLookupContext);
    }

    private static boolean isUnionType(TypeProtos.MajorType majorType) {
        return majorType.getMinorType() == TypeProtos.MinorType.UNION;
    }

    public static LogicalExpression getOrderingComparatorNullsHigh(ClassGenerator.HoldingContainer left, ClassGenerator.HoldingContainer right, FunctionLookupContext registry) {
        return FunctionGenerationHelper.getOrderingComparator(true, left, right, registry);
    }

    private static LogicalExpression getFunctionExpression(String name, ClassGenerator.HoldingContainer ... args) {
        ArrayList<LogicalExpression> argExpressions = new ArrayList<LogicalExpression>(args.length);
        for (ClassGenerator.HoldingContainer c : args) {
            argExpressions.add(new HoldingContainerExpression(c));
        }
        return new FunctionCall(name, argExpressions, ExpressionPosition.UNKNOWN);
    }

    private static LogicalExpression getTypeComparisonFunction(LogicalExpression comparisonFunction, ClassGenerator.HoldingContainer ... args) {
        ArrayList<LogicalExpression> argExpressions = Lists.newArrayList();
        ArrayList<TypeProtos.MajorType> argTypes = Lists.newArrayList();
        for (ClassGenerator.HoldingContainer c : args) {
            argTypes.add(c.getMajorType());
            argExpressions.add(new HoldingContainerExpression(c));
        }
        FunctionCall call = new FunctionCall("compareType", argExpressions, ExpressionPosition.UNKNOWN);
        ArrayList<LogicalExpression> newArgs = Lists.newArrayList();
        newArgs.add(call);
        newArgs.add(new ValueExpressions.IntExpression(0, ExpressionPosition.UNKNOWN));
        FunctionCall notEqual = new FunctionCall("not_equal", newArgs, ExpressionPosition.UNKNOWN);
        IfExpression.IfCondition ifCondition = new IfExpression.IfCondition(notEqual, call);
        IfExpression ifExpression = IfExpression.newBuilder().setIfCondition(ifCondition).setElse(comparisonFunction).build();
        return ifExpression;
    }

    private static final void appendType(TypeProtos.MajorType mt, StringBuilder sb) {
        sb.append(mt.getMinorType().name());
        sb.append(":");
        sb.append(mt.getMode().name());
    }

    private static boolean isComparableType(TypeProtos.MajorType type) {
        return type.getMinorType() != TypeProtos.MinorType.MAP && type.getMinorType() != TypeProtos.MinorType.LIST && type.getMode() != TypeProtos.DataMode.REPEATED;
    }

    private static String formatCanNotCompareMsg(TypeProtos.MajorType left, TypeProtos.MajorType right) {
        StringBuilder sb = new StringBuilder();
        sb.append("Map, Array, Union or repeated scalar type should not be used in group by, order by or in a comparison operator. Drill does not support compare between ");
        FunctionGenerationHelper.appendType(left, sb);
        sb.append(" and ");
        FunctionGenerationHelper.appendType(right, sb);
        sb.append(".");
        return sb.toString();
    }
}

