/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class ValueReference {
    private final TypeProtos.MajorType type;
    private final String name;
    private boolean isConstant;
    private boolean isFieldReader;
    private boolean isComplexWriter;
    private boolean isInternal;
    private boolean isVarArg;

    public ValueReference(TypeProtos.MajorType type, String name) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(name);
        this.type = type;
        this.name = name;
    }

    public void setConstant(boolean isConstant) {
        this.isConstant = isConstant;
    }

    public void setVarArg(boolean isVarArg) {
        this.isVarArg = isVarArg;
    }

    public TypeProtos.MajorType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public void setInternal(boolean isInternal) {
        this.isInternal = isInternal;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean isFieldReader() {
        return this.isFieldReader;
    }

    public boolean isComplexWriter() {
        return this.isComplexWriter;
    }

    public boolean isVarArg() {
        return this.isVarArg;
    }

    public String toString() {
        return "ValueReference [type=" + Types.toString(this.type) + ", name=" + this.name + "]";
    }

    public static ValueReference createFieldReaderRef(String name) {
        TypeProtos.MajorType type = Types.required(TypeProtos.MinorType.LATE);
        ValueReference ref = new ValueReference(type, name);
        ref.isFieldReader = true;
        return ref;
    }

    public static ValueReference createComplexWriterRef(String name) {
        TypeProtos.MajorType type = Types.required(TypeProtos.MinorType.LATE);
        ValueReference ref = new ValueReference(type, name);
        ref.isComplexWriter = true;
        return ref;
    }
}

