/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import io.netty.util.internal.PlatformDependent;
import org.apache.drill.exec.memory.BoundsChecking;
import org.apache.drill.shaded.guava.com.google.common.primitives.UnsignedLongs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteFunctionHelpers {
    static final Logger logger = LoggerFactory.getLogger(ByteFunctionHelpers.class);

    public static final int equal(DrillBuf left, int lStart, int lEnd, DrillBuf right, int rStart, int rEnd) {
        BoundsChecking.rangeCheck(left, lStart, lEnd, right, rStart, rEnd);
        return ByteFunctionHelpers.memEqual(left.memoryAddress(), lStart, lEnd, right.memoryAddress(), rStart, rEnd);
    }

    private static final int memEqual(long laddr, int lStart, int lEnd, long raddr, int rStart, int rEnd) {
        int n = lEnd - lStart;
        if (n == rEnd - rStart) {
            long lPos = laddr + (long)lStart;
            long rPos = raddr + (long)rStart;
            while (n > 7) {
                long rightLong;
                long leftLong = PlatformDependent.getLong(lPos);
                if (leftLong != (rightLong = PlatformDependent.getLong(rPos))) {
                    return 0;
                }
                lPos += 8L;
                rPos += 8L;
                n -= 8;
            }
            while (n-- != 0) {
                byte rightByte;
                byte leftByte = PlatformDependent.getByte(lPos);
                if (leftByte != (rightByte = PlatformDependent.getByte(rPos))) {
                    return 0;
                }
                ++lPos;
                ++rPos;
            }
            return 1;
        }
        return 0;
    }

    public static final int compare(DrillBuf left, int lStart, int lEnd, DrillBuf right, int rStart, int rEnd) {
        BoundsChecking.rangeCheck(left, lStart, lEnd, right, rStart, rEnd);
        return ByteFunctionHelpers.memcmp(left.memoryAddress(), lStart, lEnd, right.memoryAddress(), rStart, rEnd);
    }

    private static final int memcmp(long laddr, int lStart, int lEnd, long raddr, int rStart, int rEnd) {
        int n;
        int lLen = lEnd - lStart;
        int rLen = rEnd - rStart;
        long lPos = laddr + (long)lStart;
        long rPos = raddr + (long)rStart;
        for (n = Math.min(rLen, lLen); n > 7; n -= 8) {
            long rightLong;
            long leftLong = PlatformDependent.getLong(lPos);
            if (leftLong != (rightLong = PlatformDependent.getLong(rPos))) {
                return UnsignedLongs.compare(Long.reverseBytes(leftLong), Long.reverseBytes(rightLong));
            }
            lPos += 8L;
            rPos += 8L;
        }
        while (n-- != 0) {
            byte rightByte;
            byte leftByte = PlatformDependent.getByte(lPos);
            if (leftByte != (rightByte = PlatformDependent.getByte(rPos))) {
                return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
            }
            ++lPos;
            ++rPos;
        }
        if (lLen == rLen) {
            return 0;
        }
        return lLen > rLen ? 1 : -1;
    }

    public static final int compare(DrillBuf left, int lStart, int lEnd, byte[] right, int rStart, int rEnd) {
        BoundsChecking.rangeCheck(left, lStart, lEnd);
        return ByteFunctionHelpers.memcmp(left.memoryAddress(), lStart, lEnd, right, rStart, rEnd);
    }

    private static final int memcmp(long laddr, int lStart, int lEnd, byte[] right, int rStart, int rEnd) {
        int lLen = lEnd - lStart;
        int rLen = rEnd - rStart;
        int n = Math.min(rLen, lLen);
        long lPos = laddr + (long)lStart;
        int rPos = rStart;
        while (n-- != 0) {
            byte rightByte;
            byte leftByte = PlatformDependent.getByte(lPos);
            if (leftByte != (rightByte = right[rPos])) {
                return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
            }
            ++lPos;
            ++rPos;
        }
        if (lLen == rLen) {
            return 0;
        }
        return lLen > rLen ? 1 : -1;
    }

    public static int getInteger(byte[] b, int index) {
        return ByteFunctionHelpers.getInteger(b, index, true);
    }

    public static int getInteger(byte[] b, int index, boolean ignoreSign) {
        int startIndex = index * 4;
        if (index == 0 && ignoreSign) {
            return b[startIndex + 3] & 0xFF | (b[startIndex + 2] & 0xFF) << 8 | (b[startIndex + 1] & 0xFF) << 16 | (b[startIndex] & 0x7F) << 24;
        }
        return b[startIndex + 3] & 0xFF | (b[startIndex + 2] & 0xFF) << 8 | (b[startIndex + 1] & 0xFF) << 16 | (b[startIndex] & 0xFF) << 24;
    }

    public static void setInteger(byte[] b, int index, int value) {
        int startIndex = index * 4;
        b[startIndex] = (byte)(value >> 24 & 0xFF);
        b[startIndex + 1] = (byte)(value >> 16 & 0xFF);
        b[startIndex + 2] = (byte)(value >> 8 & 0xFF);
        b[startIndex + 3] = (byte)(value & 0xFF);
    }

    public static void setSign(byte[] b, boolean sign) {
        int value = ByteFunctionHelpers.getInteger(b, 0);
        if (sign) {
            ByteFunctionHelpers.setInteger(b, 0, value | Integer.MIN_VALUE);
        } else {
            ByteFunctionHelpers.setInteger(b, 0, value & Integer.MAX_VALUE);
        }
    }

    public static boolean getSign(byte[] b) {
        return (ByteFunctionHelpers.getInteger(b, 0, false) & Integer.MIN_VALUE) != 0;
    }
}

