/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Var16CharHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

@FunctionTemplate(names={"castVAR16CHAR", "to_var16char", "to_string"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
public class CastVarCharVar16Char
implements DrillSimpleFunc {
    @Param
    VarCharHolder in;
    @Param
    BigIntHolder length;
    @Output
    Var16CharHolder out;
    @Workspace
    Charset charset;
    @Inject
    DrillBuf buffer;

    @Override
    public void setup() {
        this.charset = StandardCharsets.UTF_16;
    }

    @Override
    public void eval() {
        byte[] buf = StringFunctionHelpers.toStringFromUTF8(this.in.start, this.in.end, this.in.buffer).getBytes(this.charset);
        this.buffer.setBytes(0, buf);
        this.out.start = 0;
        this.out.end = buf.length;
        this.out.buffer = this.buffer;
    }
}

