/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class CharSequenceWrapper
implements CharSequence {
    private DrillBuf buffer;
    private CharBuffer charBuffer;
    private static final int INITIAL_CHAR_BUF = 1024;
    private CharsetDecoder decoder;
    private int start;
    private int end;
    private boolean usAscii;

    public CharSequenceWrapper() {
    }

    public CharSequenceWrapper(int start, int end, DrillBuf buffer) {
        this.setBuffer(start, end, buffer);
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        if (this.usAscii) {
            return (char)(this.buffer.getByte(this.start + index) & 0xFF);
        }
        return this.charBuffer.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public void setBuffer(int start, int end, DrillBuf buffer) {
        this.usAscii = this.isAscii(start, end, buffer);
        if (this.usAscii) {
            this.start = start;
            this.end = end;
            this.buffer = buffer;
        } else {
            this.initCharBuffer();
            ByteBuffer byteBuf = buffer.nioBuffer(start, end - start);
            while (this.charBuffer.capacity() < Integer.MAX_VALUE) {
                byteBuf.mark();
                if (this.decodeUT8(byteBuf)) break;
                this.growCharBuffer();
                byteBuf.reset();
            }
            this.start = 0;
            this.end = this.charBuffer.position();
            this.charBuffer.rewind();
        }
    }

    private boolean isAscii(int start, int end, DrillBuf buffer) {
        for (int i = start; i < end; ++i) {
            byte bb = buffer.getByte(i);
            if (bb >= 0) continue;
            return false;
        }
        return true;
    }

    private void initCharBuffer() {
        if (this.charBuffer == null) {
            this.charBuffer = CharBuffer.allocate(1024);
        }
        if (this.decoder == null) {
            this.decoder = StandardCharsets.UTF_8.newDecoder();
        }
    }

    private boolean decodeUT8(ByteBuffer byteBuf) {
        boolean endOfInput = true;
        this.decoder.reset();
        this.charBuffer.rewind();
        CoderResult result = this.decoder.decode(byteBuf, this.charBuffer, endOfInput);
        if (result.isOverflow()) {
            return false;
        }
        if (result.isError()) {
            try {
                result.throwException();
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private void growCharBuffer() {
        int oldCapacity = this.charBuffer.capacity();
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        }
        this.charBuffer = CharBuffer.allocate(newCapacity);
    }

    @Override
    public String toString() {
        throw new UnsupportedOperationException();
    }
}

