/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.vector.complex.MapUtility;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;

@FunctionTemplate(name="collect_to_list", isVarArg=true, scope=FunctionTemplate.FunctionScope.SIMPLE)
public class CollectToListFunction
implements DrillSimpleFunc {
    @Param
    FieldReader[] inputReaders;
    @Output
    BaseWriter.ComplexWriter outWriter;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
        BaseWriter.ListWriter listWriter = this.outWriter.rootAsList();
        if (this.inputReaders.length == 0) {
            listWriter.integer();
        } else {
            for (FieldReader fieldReader : this.inputReaders) {
                MapUtility.writeToListFromReader(fieldReader, listWriter, "CollectToListFunction");
            }
        }
    }
}

