/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;

@FunctionTemplate(name="collect_to_list_varchar", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE, isInternal=true)
public class CollectToListVarcharAggFunction
implements DrillAggFunc {
    @Param
    NullableVarCharHolder input;
    @Output
    BaseWriter.ComplexWriter writer;
    @Workspace
    ObjectHolder writerHolder;

    @Override
    public void setup() {
        this.writerHolder = new ObjectHolder();
    }

    @Override
    public void add() {
        if (this.writerHolder.obj == null) {
            this.writerHolder.obj = this.writer.rootAsList();
        }
        BaseWriter.ListWriter listWriter = (BaseWriter.ListWriter)this.writerHolder.obj;
        if (this.input.isSet > 0) {
            listWriter.varChar().writeVarChar(this.input.start, this.input.end, this.input.buffer);
        }
    }

    @Override
    public void output() {
    }

    @Override
    public void reset() {
        this.writerHolder.obj = null;
    }
}

