/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;

public class GCompareFloat8VsFloat8 {

    @FunctionTemplate(names={"not_equal", "<>", "!="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NotEqualsFloat8VsFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder left;
        @Param
        Float8Holder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (this.left.value != this.right.value ? 1 : 0);
        }
    }

    @FunctionTemplate(names={"equal", "==", "="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EqualsFloat8VsFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder left;
        @Param
        Float8Holder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 1 : (this.left.value == this.right.value ? 1 : 0);
        }
    }

    @FunctionTemplate(names={"greater_than_or_equal_to", ">="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanEqFloat8VsFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder left;
        @Param
        Float8Holder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) ? 1 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (this.left.value >= this.right.value ? 1 : 0));
        }
    }

    @FunctionTemplate(names={"greater_than", ">"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanFloat8VsFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder left;
        @Param
        Float8Holder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.right.value) || Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value > this.right.value ? 1 : 0));
        }
    }

    @FunctionTemplate(names={"less_than_or_equal_to", "<="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanEqFloat8VsFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder left;
        @Param
        Float8Holder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.right.value) ? 1 : (!Double.isNaN(this.right.value) && Double.isNaN(this.left.value) ? 0 : (this.left.value <= this.right.value ? 1 : 0));
        }
    }

    @FunctionTemplate(names={"less_than", "<"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanFloat8VsFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder left;
        @Param
        Float8Holder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) || Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (Double.isNaN(this.right.value) && !Double.isNaN(this.left.value) ? 1 : (this.left.value < this.right.value ? 1 : 0));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableFloat8VsNullableFloat8NullLow
    implements DrillSimpleFunc {
        @Param
        NullableFloat8Holder left;
        @Param
        NullableFloat8Holder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : -1) : (this.right.isSet == 0 ? 1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1))))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableFloat8VsNullableFloat8NullHigh
    implements DrillSimpleFunc {
        @Param
        NullableFloat8Holder left;
        @Param
        NullableFloat8Holder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : 1) : (this.right.isSet == 0 ? -1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1))))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableFloat8VsFloat8NullLow
    implements DrillSimpleFunc {
        @Param
        NullableFloat8Holder left;
        @Param
        Float8Holder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? -1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableFloat8VsFloat8NullHigh
    implements DrillSimpleFunc {
        @Param
        NullableFloat8Holder left;
        @Param
        Float8Holder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? 1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareFloat8VsNullableFloat8NullLow
    implements DrillSimpleFunc {
        @Param
        Float8Holder left;
        @Param
        NullableFloat8Holder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.isSet == 0 ? 1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareFloat8VsNullableFloat8NullHigh
    implements DrillSimpleFunc {
        @Param
        Float8Holder left;
        @Param
        NullableFloat8Holder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.isSet == 0 ? -1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareFloat8VsFloat8NullLow
    implements DrillSimpleFunc {
        @Param
        Float8Holder left;
        @Param
        Float8Holder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareFloat8VsFloat8NullHigh
    implements DrillSimpleFunc {
        @Param
        Float8Holder left;
        @Param
        Float8Holder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1))));
        }
    }
}

