/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;

public class GCompareIntervalDayVsIntervalDay {

    @FunctionTemplate(names={"not_equal", "<>", "!="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NotEqualsIntervalDayVsIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            MutableDateTime leftDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            MutableDateTime rightDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            leftDate.addMonths(0);
            leftDate.addDays(this.left.days);
            leftDate.add((long)this.left.milliseconds);
            rightDate.addMonths(0);
            rightDate.addDays(this.right.days);
            rightDate.add((long)this.right.milliseconds);
            long leftMS = leftDate.getMillis();
            long rightMS = rightDate.getMillis();
            int cmp = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);
            this.out.value = cmp == 0 ? 0 : 1;
        }
    }

    @FunctionTemplate(names={"equal", "==", "="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EqualsIntervalDayVsIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            MutableDateTime leftDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            MutableDateTime rightDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            leftDate.addMonths(0);
            leftDate.addDays(this.left.days);
            leftDate.add((long)this.left.milliseconds);
            rightDate.addMonths(0);
            rightDate.addDays(this.right.days);
            rightDate.add((long)this.right.milliseconds);
            long leftMS = leftDate.getMillis();
            long rightMS = rightDate.getMillis();
            int cmp = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);
            this.out.value = cmp == 0 ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"greater_than_or_equal_to", ">="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanEqIntervalDayVsIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            MutableDateTime leftDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            MutableDateTime rightDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            leftDate.addMonths(0);
            leftDate.addDays(this.left.days);
            leftDate.add((long)this.left.milliseconds);
            rightDate.addMonths(0);
            rightDate.addDays(this.right.days);
            rightDate.add((long)this.right.milliseconds);
            long leftMS = leftDate.getMillis();
            long rightMS = rightDate.getMillis();
            int cmp = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);
            this.out.value = cmp > -1 ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"greater_than", ">"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanIntervalDayVsIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            MutableDateTime leftDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            MutableDateTime rightDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            leftDate.addMonths(0);
            leftDate.addDays(this.left.days);
            leftDate.add((long)this.left.milliseconds);
            rightDate.addMonths(0);
            rightDate.addDays(this.right.days);
            rightDate.add((long)this.right.milliseconds);
            long leftMS = leftDate.getMillis();
            long rightMS = rightDate.getMillis();
            int cmp = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);
            this.out.value = cmp == 1 ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than_or_equal_to", "<="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanEqIntervalDayVsIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            MutableDateTime leftDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            MutableDateTime rightDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            leftDate.addMonths(0);
            leftDate.addDays(this.left.days);
            leftDate.add((long)this.left.milliseconds);
            rightDate.addMonths(0);
            rightDate.addDays(this.right.days);
            rightDate.add((long)this.right.milliseconds);
            long leftMS = leftDate.getMillis();
            long rightMS = rightDate.getMillis();
            int cmp = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);
            this.out.value = cmp < 1 ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than", "<"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanIntervalDayVsIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            MutableDateTime leftDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            MutableDateTime rightDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            leftDate.addMonths(0);
            leftDate.addDays(this.left.days);
            leftDate.add((long)this.left.milliseconds);
            rightDate.addMonths(0);
            rightDate.addDays(this.right.days);
            rightDate.add((long)this.right.milliseconds);
            long leftMS = leftDate.getMillis();
            long rightMS = rightDate.getMillis();
            int cmp = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);
            this.out.value = cmp == -1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableIntervalDayVsNullableIntervalDayNullLow
    implements DrillSimpleFunc {
        @Param
        NullableIntervalDayHolder left;
        @Param
        NullableIntervalDayHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (this.left.isSet == 0) {
                this.out.value = this.right.isSet == 0 ? 0 : -1;
            } else if (this.right.isSet == 0) {
                this.out.value = 1;
            } else {
                MutableDateTime leftDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
                MutableDateTime rightDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
                leftDate.addMonths(0);
                leftDate.addDays(this.left.days);
                leftDate.add((long)this.left.milliseconds);
                rightDate.addMonths(0);
                rightDate.addDays(this.right.days);
                rightDate.add((long)this.right.milliseconds);
                long leftMS = leftDate.getMillis();
                long rightMS = rightDate.getMillis();
                this.out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);
            }
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableIntervalDayVsNullableIntervalDayNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableIntervalDayHolder left;
        @Param
        NullableIntervalDayHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (this.left.isSet == 0) {
                this.out.value = this.right.isSet == 0 ? 0 : 1;
            } else if (this.right.isSet == 0) {
                this.out.value = -1;
            } else {
                MutableDateTime leftDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
                MutableDateTime rightDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
                leftDate.addMonths(0);
                leftDate.addDays(this.left.days);
                leftDate.add((long)this.left.milliseconds);
                rightDate.addMonths(0);
                rightDate.addDays(this.right.days);
                rightDate.add((long)this.right.milliseconds);
                long leftMS = leftDate.getMillis();
                long rightMS = rightDate.getMillis();
                this.out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);
            }
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableIntervalDayVsIntervalDayNullLow
    implements DrillSimpleFunc {
        @Param
        NullableIntervalDayHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (this.left.isSet == 0) {
                this.out.value = -1;
            } else {
                MutableDateTime leftDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
                MutableDateTime rightDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
                leftDate.addMonths(0);
                leftDate.addDays(this.left.days);
                leftDate.add((long)this.left.milliseconds);
                rightDate.addMonths(0);
                rightDate.addDays(this.right.days);
                rightDate.add((long)this.right.milliseconds);
                long leftMS = leftDate.getMillis();
                long rightMS = rightDate.getMillis();
                this.out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);
            }
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableIntervalDayVsIntervalDayNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableIntervalDayHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (this.left.isSet == 0) {
                this.out.value = 1;
            } else {
                MutableDateTime leftDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
                MutableDateTime rightDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
                leftDate.addMonths(0);
                leftDate.addDays(this.left.days);
                leftDate.add((long)this.left.milliseconds);
                rightDate.addMonths(0);
                rightDate.addDays(this.right.days);
                rightDate.add((long)this.right.milliseconds);
                long leftMS = leftDate.getMillis();
                long rightMS = rightDate.getMillis();
                this.out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);
            }
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareIntervalDayVsNullableIntervalDayNullLow
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        NullableIntervalDayHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (this.right.isSet == 0) {
                this.out.value = 1;
            } else {
                MutableDateTime leftDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
                MutableDateTime rightDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
                leftDate.addMonths(0);
                leftDate.addDays(this.left.days);
                leftDate.add((long)this.left.milliseconds);
                rightDate.addMonths(0);
                rightDate.addDays(this.right.days);
                rightDate.add((long)this.right.milliseconds);
                long leftMS = leftDate.getMillis();
                long rightMS = rightDate.getMillis();
                this.out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);
            }
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareIntervalDayVsNullableIntervalDayNullHigh
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        NullableIntervalDayHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (this.right.isSet == 0) {
                this.out.value = -1;
            } else {
                MutableDateTime leftDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
                MutableDateTime rightDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
                leftDate.addMonths(0);
                leftDate.addDays(this.left.days);
                leftDate.add((long)this.left.milliseconds);
                rightDate.addMonths(0);
                rightDate.addDays(this.right.days);
                rightDate.add((long)this.right.milliseconds);
                long leftMS = leftDate.getMillis();
                long rightMS = rightDate.getMillis();
                this.out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);
            }
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareIntervalDayVsIntervalDayNullLow
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            MutableDateTime leftDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            MutableDateTime rightDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            leftDate.addMonths(0);
            leftDate.addDays(this.left.days);
            leftDate.add((long)this.left.milliseconds);
            rightDate.addMonths(0);
            rightDate.addDays(this.right.days);
            rightDate.add((long)this.right.milliseconds);
            long leftMS = leftDate.getMillis();
            long rightMS = rightDate.getMillis();
            this.out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareIntervalDayVsIntervalDayNullHigh
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            MutableDateTime leftDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            MutableDateTime rightDate = new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            leftDate.addMonths(0);
            leftDate.addDays(this.left.days);
            leftDate.add((long)this.left.milliseconds);
            rightDate.addMonths(0);
            rightDate.addDays(this.right.days);
            rightDate.add((long)this.right.milliseconds);
            long leftMS = leftDate.getMillis();
            long rightMS = rightDate.getMillis();
            this.out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);
        }
    }
}

