/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;

public class GCompareTimeVsTime {

    @FunctionTemplate(names={"not_equal", "<>", "!="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NotEqualsTimeVsTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (this.left.value != this.right.value ? 1 : 0);
        }
    }

    @FunctionTemplate(names={"equal", "==", "="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EqualsTimeVsTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 1 : (this.left.value == this.right.value ? 1 : 0);
        }
    }

    @FunctionTemplate(names={"greater_than_or_equal_to", ">="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanEqTimeVsTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) ? 1 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (this.left.value >= this.right.value ? 1 : 0));
        }
    }

    @FunctionTemplate(names={"greater_than", ">"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanTimeVsTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.right.value) || Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value > this.right.value ? 1 : 0));
        }
    }

    @FunctionTemplate(names={"less_than_or_equal_to", "<="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanEqTimeVsTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.right.value) ? 1 : (!Double.isNaN(this.right.value) && Double.isNaN(this.left.value) ? 0 : (this.left.value <= this.right.value ? 1 : 0));
        }
    }

    @FunctionTemplate(names={"less_than", "<"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanTimeVsTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) || Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (Double.isNaN(this.right.value) && !Double.isNaN(this.left.value) ? 1 : (this.left.value < this.right.value ? 1 : 0));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableTimeVsNullableTimeNullLow
    implements DrillSimpleFunc {
        @Param
        NullableTimeHolder left;
        @Param
        NullableTimeHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : -1) : (this.right.isSet == 0 ? 1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1))))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableTimeVsNullableTimeNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableTimeHolder left;
        @Param
        NullableTimeHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : 1) : (this.right.isSet == 0 ? -1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1))))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableTimeVsTimeNullLow
    implements DrillSimpleFunc {
        @Param
        NullableTimeHolder left;
        @Param
        TimeHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? -1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableTimeVsTimeNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableTimeHolder left;
        @Param
        TimeHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? 1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareTimeVsNullableTimeNullLow
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        NullableTimeHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.isSet == 0 ? 1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareTimeVsNullableTimeNullHigh
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        NullableTimeHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.isSet == 0 ? -1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareTimeVsTimeNullLow
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareTimeVsTimeNullHigh
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1))));
        }
    }
}

