/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

public class GCompareVarCharVsVarBinary {

    @FunctionTemplate(names={"not_equal", "<>", "!="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NotEqualsVarCharVsVarBinary
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        VarBinaryHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
            this.out.value = cmp == 0 ? 0 : 1;
        }
    }

    @FunctionTemplate(names={"equal", "==", "="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EqualsVarCharVsVarBinary
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        VarBinaryHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ByteFunctionHelpers.equal(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
        }
    }

    @FunctionTemplate(names={"greater_than_or_equal_to", ">="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanEqVarCharVsVarBinary
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        VarBinaryHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
            this.out.value = cmp > -1 ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"greater_than", ">"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanVarCharVsVarBinary
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        VarBinaryHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
            this.out.value = cmp == 1 ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than_or_equal_to", "<="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanEqVarCharVsVarBinary
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        VarBinaryHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
            this.out.value = cmp < 1 ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than", "<"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanVarCharVsVarBinary
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        VarBinaryHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
            this.out.value = cmp == -1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableVarCharVsNullableVarBinaryNullLow
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder left;
        @Param
        NullableVarBinaryHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : -1) : (this.right.isSet == 0 ? 1 : ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableVarCharVsNullableVarBinaryNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder left;
        @Param
        NullableVarBinaryHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : 1) : (this.right.isSet == 0 ? -1 : ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableVarCharVsVarBinaryNullLow
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder left;
        @Param
        VarBinaryHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? -1 : ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableVarCharVsVarBinaryNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder left;
        @Param
        VarBinaryHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? 1 : ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareVarCharVsNullableVarBinaryNullLow
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        NullableVarBinaryHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.isSet == 0 ? 1 : ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareVarCharVsNullableVarBinaryNullHigh
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        NullableVarBinaryHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.isSet == 0 ? -1 : ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareVarCharVsVarBinaryNullLow
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        VarBinaryHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareVarCharVsVarBinaryNullHigh
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        VarBinaryHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
        }
    }
}

