/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.MutableDateTime;

public class GDateTimeTruncateFunctions {

    @FunctionTemplate(names={"date_trunc_Millennium"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalYearMillenniumDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder right;
        @Output
        IntervalYearHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = this.right.value / 12000 * 12000;
        }
    }

    @FunctionTemplate(names={"date_trunc_Century"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalYearCenturyDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder right;
        @Output
        IntervalYearHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = this.right.value / 1200 * 1200;
        }
    }

    @FunctionTemplate(names={"date_trunc_Decade"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalYearDecadeDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder right;
        @Output
        IntervalYearHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = this.right.value / 120 * 120;
        }
    }

    @FunctionTemplate(names={"date_trunc_Quarter"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalYearQuarterDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder right;
        @Output
        IntervalYearHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = this.right.value / 3 * 3;
        }
    }

    @FunctionTemplate(names={"date_trunc_Year"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalYearYearDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder right;
        @Output
        IntervalYearHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = this.right.value / 12 * 12;
        }
    }

    @FunctionTemplate(names={"date_trunc_Month"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalYearMonthDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder right;
        @Output
        IntervalYearHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = this.right.value;
        }
    }

    @FunctionTemplate(names={"date_trunc_Day"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalYearDayDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder right;
        @Output
        IntervalYearHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = this.right.value;
        }
    }

    @FunctionTemplate(names={"date_trunc_Hour"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalYearHourDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder right;
        @Output
        IntervalYearHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = this.right.value;
        }
    }

    @FunctionTemplate(names={"date_trunc_Minute"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalYearMinuteDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder right;
        @Output
        IntervalYearHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = this.right.value;
        }
    }

    @FunctionTemplate(names={"date_trunc_Second"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalYearSecondDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder right;
        @Output
        IntervalYearHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = this.right.value;
        }
    }

    @FunctionTemplate(name="date_trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalYearDummyDateTrunc
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        IntervalYearHolder right;
        @Output
        IntervalYearHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(names={"date_trunc_Millennium"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalDayMillenniumDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.days = 0;
            this.out.milliseconds = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Century"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalDayCenturyDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.days = 0;
            this.out.milliseconds = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Decade"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalDayDecadeDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.days = 0;
            this.out.milliseconds = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Quarter"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalDayQuarterDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.days = 0;
            this.out.milliseconds = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Year"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalDayYearDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.days = 0;
            this.out.milliseconds = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Month"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalDayMonthDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.days = 0;
            this.out.milliseconds = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Day"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalDayDayDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.days = this.right.days;
            this.out.milliseconds = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Hour"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalDayHourDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.days = this.right.days;
            this.out.milliseconds = this.right.milliseconds / 3600000 * 3600000;
        }
    }

    @FunctionTemplate(names={"date_trunc_Minute"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalDayMinuteDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.days = this.right.days;
            this.out.milliseconds = this.right.milliseconds / 60000 * 60000;
        }
    }

    @FunctionTemplate(names={"date_trunc_Second"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalDaySecondDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.days = this.right.days;
            this.out.milliseconds = this.right.milliseconds / 1000 * 1000;
        }
    }

    @FunctionTemplate(name="date_trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalDayDummyDateTrunc
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(names={"date_trunc_Millennium"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalMillenniumDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalHolder right;
        @Output
        IntervalHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.months = this.right.months / 12000 * 12000;
            this.out.days = 0;
            this.out.milliseconds = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Century"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalCenturyDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalHolder right;
        @Output
        IntervalHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.months = this.right.months / 1200 * 1200;
            this.out.days = 0;
            this.out.milliseconds = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Decade"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalDecadeDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalHolder right;
        @Output
        IntervalHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.months = this.right.months / 120 * 120;
            this.out.days = 0;
            this.out.milliseconds = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Quarter"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalQuarterDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalHolder right;
        @Output
        IntervalHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.months = this.right.months / 3 * 3;
            this.out.days = 0;
            this.out.milliseconds = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Year"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalYearDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalHolder right;
        @Output
        IntervalHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.months = this.right.months / 12 * 12;
            this.out.days = 0;
            this.out.milliseconds = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Month"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalMonthDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalHolder right;
        @Output
        IntervalHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.months = this.right.months;
            this.out.days = 0;
            this.out.milliseconds = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Day"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalDayDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalHolder right;
        @Output
        IntervalHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.months = this.right.months;
            this.out.days = this.right.days;
            this.out.milliseconds = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Hour"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalHourDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalHolder right;
        @Output
        IntervalHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.months = this.right.months;
            this.out.days = this.right.days;
            this.out.milliseconds = this.right.milliseconds / 3600000 * 3600000;
        }
    }

    @FunctionTemplate(names={"date_trunc_Minute"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalMinuteDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalHolder right;
        @Output
        IntervalHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.months = this.right.months;
            this.out.days = this.right.days;
            this.out.milliseconds = this.right.milliseconds / 60000 * 60000;
        }
    }

    @FunctionTemplate(names={"date_trunc_Second"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalSecondDateTrunc
    implements DrillSimpleFunc {
        @Param
        IntervalHolder right;
        @Output
        IntervalHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.months = this.right.months;
            this.out.days = this.right.days;
            this.out.milliseconds = this.right.milliseconds / 1000 * 1000;
        }
    }

    @FunctionTemplate(name="date_trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GIntervalDummyDateTrunc
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        IntervalHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(names={"date_trunc_Millennium"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeMillenniumDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeHolder right;
        @Output
        TimeHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Century"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeCenturyDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeHolder right;
        @Output
        TimeHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Decade"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeDecadeDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeHolder right;
        @Output
        TimeHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Quarter"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeQuarterDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeHolder right;
        @Output
        TimeHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Year"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeYearDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeHolder right;
        @Output
        TimeHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Month"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeMonthDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeHolder right;
        @Output
        TimeHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Day"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeDayDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeHolder right;
        @Output
        TimeHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = 0;
        }
    }

    @FunctionTemplate(names={"date_trunc_Hour"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeHourDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeHolder right;
        @Output
        TimeHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis((long)this.right.value);
            this.dateTime.setRounding(this.dateTime.getChronology().hourOfDay());
            this.out.value = (int)this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Minute"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeMinuteDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeHolder right;
        @Output
        TimeHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis((long)this.right.value);
            this.dateTime.setRounding(this.dateTime.getChronology().minuteOfHour());
            this.out.value = (int)this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Second"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeSecondDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeHolder right;
        @Output
        TimeHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis((long)this.right.value);
            this.dateTime.setRounding(this.dateTime.getChronology().secondOfMinute());
            this.out.value = (int)this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(name="date_trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeDummyDateTrunc
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        TimeHolder right;
        @Output
        TimeHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(names={"date_trunc_Millennium"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeStampMillenniumDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder right;
        @Output
        TimeStampHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            int year = this.dateTime.getYear();
            this.dateTime.setRounding(this.dateTime.getChronology().era());
            this.dateTime2.setMillis(this.dateTime.getMillis());
            this.dateTime2.add(DurationFieldType.years(), (year - 1) / 1000 * 1000);
            this.out.value = this.dateTime2.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Century"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeStampCenturyDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder right;
        @Output
        TimeStampHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            this.dateTime.add(DurationFieldType.years(), -1);
            this.dateTime.setRounding(this.dateTime.getChronology().centuryOfEra());
            this.dateTime2.setMillis(this.dateTime.getMillis());
            this.dateTime2.add(DurationFieldType.years(), 1);
            this.out.value = this.dateTime2.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Decade"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeStampDecadeDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder right;
        @Output
        TimeStampHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            int year = this.dateTime.getYear();
            this.dateTime.setRounding(this.dateTime.getChronology().centuryOfEra());
            this.dateTime2.setMillis(this.dateTime.getMillis());
            this.dateTime2.add(DurationFieldType.years(), year % 100 / 10 * 10);
            this.out.value = this.dateTime2.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Quarter"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeStampQuarterDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder right;
        @Output
        TimeStampHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            int month = this.dateTime.getMonthOfYear();
            this.dateTime.setRounding(this.dateTime.getChronology().year());
            this.dateTime2.setMillis(this.dateTime.getMillis());
            this.dateTime2.add(DurationFieldType.months(), (month - 1) / 3 * 3);
            this.out.value = this.dateTime2.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Week"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeStampWeekDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder right;
        @Output
        TimeStampHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            this.dateTime.setRounding(this.dateTime.getChronology().weekOfWeekyear());
            this.out.value = this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Year"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeStampYearDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder right;
        @Output
        TimeStampHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            this.dateTime.setRounding(this.dateTime.getChronology().year());
            this.out.value = this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Month"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeStampMonthDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder right;
        @Output
        TimeStampHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            this.dateTime.setRounding(this.dateTime.getChronology().monthOfYear());
            this.out.value = this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Day"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeStampDayDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder right;
        @Output
        TimeStampHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            this.dateTime.setRounding(this.dateTime.getChronology().dayOfMonth());
            this.out.value = this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Hour"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeStampHourDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder right;
        @Output
        TimeStampHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            this.dateTime.setRounding(this.dateTime.getChronology().hourOfDay());
            this.out.value = this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Minute"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeStampMinuteDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder right;
        @Output
        TimeStampHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            this.dateTime.setRounding(this.dateTime.getChronology().minuteOfHour());
            this.out.value = this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Second"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeStampSecondDateTrunc
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder right;
        @Output
        TimeStampHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            this.dateTime.setRounding(this.dateTime.getChronology().secondOfMinute());
            this.out.value = this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(name="date_trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeStampDummyDateTrunc
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        TimeStampHolder right;
        @Output
        TimeStampHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(names={"date_trunc_Millennium"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GDateMillenniumDateTrunc
    implements DrillSimpleFunc {
        @Param
        DateHolder right;
        @Output
        DateHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            int year = this.dateTime.getYear();
            this.dateTime.setRounding(this.dateTime.getChronology().era());
            this.dateTime2.setMillis(this.dateTime.getMillis());
            this.dateTime2.add(DurationFieldType.years(), (year - 1) / 1000 * 1000);
            this.out.value = this.dateTime2.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Century"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GDateCenturyDateTrunc
    implements DrillSimpleFunc {
        @Param
        DateHolder right;
        @Output
        DateHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            this.dateTime.add(DurationFieldType.years(), -1);
            this.dateTime.setRounding(this.dateTime.getChronology().centuryOfEra());
            this.dateTime2.setMillis(this.dateTime.getMillis());
            this.dateTime2.add(DurationFieldType.years(), 1);
            this.out.value = this.dateTime2.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Decade"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GDateDecadeDateTrunc
    implements DrillSimpleFunc {
        @Param
        DateHolder right;
        @Output
        DateHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            int year = this.dateTime.getYear();
            this.dateTime.setRounding(this.dateTime.getChronology().centuryOfEra());
            this.dateTime2.setMillis(this.dateTime.getMillis());
            this.dateTime2.add(DurationFieldType.years(), year % 100 / 10 * 10);
            this.out.value = this.dateTime2.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Quarter"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GDateQuarterDateTrunc
    implements DrillSimpleFunc {
        @Param
        DateHolder right;
        @Output
        DateHolder out;
        @Workspace
        MutableDateTime dateTime;
        @Workspace
        MutableDateTime dateTime2;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
            this.dateTime2 = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            int month = this.dateTime.getMonthOfYear();
            this.dateTime.setRounding(this.dateTime.getChronology().year());
            this.dateTime2.setMillis(this.dateTime.getMillis());
            this.dateTime2.add(DurationFieldType.months(), (month - 1) / 3 * 3);
            this.out.value = this.dateTime2.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Week"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GDateWeekDateTrunc
    implements DrillSimpleFunc {
        @Param
        DateHolder right;
        @Output
        DateHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            this.dateTime.setRounding(this.dateTime.getChronology().weekOfWeekyear());
            this.out.value = this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Year"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GDateYearDateTrunc
    implements DrillSimpleFunc {
        @Param
        DateHolder right;
        @Output
        DateHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            this.dateTime.setRounding(this.dateTime.getChronology().year());
            this.out.value = this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Month"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GDateMonthDateTrunc
    implements DrillSimpleFunc {
        @Param
        DateHolder right;
        @Output
        DateHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.right.value);
            this.dateTime.setRounding(this.dateTime.getChronology().monthOfYear());
            this.out.value = this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc_Day"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GDateDayDateTrunc
    implements DrillSimpleFunc {
        @Param
        DateHolder right;
        @Output
        DateHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = this.right.value;
        }
    }

    @FunctionTemplate(names={"date_trunc_Hour"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GDateHourDateTrunc
    implements DrillSimpleFunc {
        @Param
        DateHolder right;
        @Output
        DateHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = this.right.value;
        }
    }

    @FunctionTemplate(names={"date_trunc_Minute"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GDateMinuteDateTrunc
    implements DrillSimpleFunc {
        @Param
        DateHolder right;
        @Output
        DateHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = this.right.value;
        }
    }

    @FunctionTemplate(names={"date_trunc_Second"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GDateSecondDateTrunc
    implements DrillSimpleFunc {
        @Param
        DateHolder right;
        @Output
        DateHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.out.value = this.right.value;
        }
    }

    @FunctionTemplate(name="date_trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GDateDummyDateTrunc
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        DateHolder right;
        @Output
        DateHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }
}

