/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal18Holder;
import org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.apache.drill.exec.expr.holders.Var16CharHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;

public class GNewValueFunctions {

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueBit
    implements DrillSimpleFunc {
        @Param
        BitHolder in;
        @Workspace
        BitHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueBitNullable
    implements DrillSimpleFunc {
        @Param
        NullableBitHolder in;
        @Workspace
        NullableBitHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueVarDecimal
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder in;
        @Workspace
        VarDecimalHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
            this.initialized = false;
            this.previous.buffer = this.buf;
            this.previous.start = 0;
        }

        @Override
        public void eval() {
            int length = this.in.end - this.in.start;
            if (this.initialized.booleanValue()) {
                if (ByteFunctionHelpers.compare(this.previous.buffer, 0, this.previous.end, this.in.buffer, this.in.start, this.in.end) == 0) {
                    this.out.value = 0;
                } else {
                    this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                    this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                    this.previous.end = length;
                    this.out.value = 1;
                }
            } else {
                this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                this.previous.end = length;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueVarDecimalNullable
    implements DrillSimpleFunc {
        @Param
        NullableVarDecimalHolder in;
        @Workspace
        NullableVarDecimalHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
            this.initialized = false;
            this.previous.buffer = this.buf;
            this.previous.start = 0;
        }

        @Override
        public void eval() {
            int length;
            int n = length = this.in.isSet == 0 ? 0 : this.in.end - this.in.start;
            if (this.initialized.booleanValue()) {
                if (this.previous.isSet == 0 && this.in.isSet == 0) {
                    this.out.value = 0;
                } else if (this.previous.isSet != 0 && this.in.isSet != 0 && ByteFunctionHelpers.compare(this.previous.buffer, 0, this.previous.end, this.in.buffer, this.in.start, this.in.end) == 0) {
                    this.out.value = 0;
                } else {
                    if (this.in.isSet == 1) {
                        this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                        this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                        this.previous.end = length;
                    }
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                if (this.in.isSet == 1) {
                    this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                    this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                    this.previous.end = length;
                }
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueVar16Char
    implements DrillSimpleFunc {
        @Param
        Var16CharHolder in;
        @Workspace
        Var16CharHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
            this.initialized = false;
            this.previous.buffer = this.buf;
            this.previous.start = 0;
        }

        @Override
        public void eval() {
            int length = this.in.end - this.in.start;
            if (this.initialized.booleanValue()) {
                if (ByteFunctionHelpers.compare(this.previous.buffer, 0, this.previous.end, this.in.buffer, this.in.start, this.in.end) == 0) {
                    this.out.value = 0;
                } else {
                    this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                    this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                    this.previous.end = length;
                    this.out.value = 1;
                }
            } else {
                this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                this.previous.end = length;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueVar16CharNullable
    implements DrillSimpleFunc {
        @Param
        NullableVar16CharHolder in;
        @Workspace
        NullableVar16CharHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
            this.initialized = false;
            this.previous.buffer = this.buf;
            this.previous.start = 0;
        }

        @Override
        public void eval() {
            int length;
            int n = length = this.in.isSet == 0 ? 0 : this.in.end - this.in.start;
            if (this.initialized.booleanValue()) {
                if (this.previous.isSet == 0 && this.in.isSet == 0) {
                    this.out.value = 0;
                } else if (this.previous.isSet != 0 && this.in.isSet != 0 && ByteFunctionHelpers.compare(this.previous.buffer, 0, this.previous.end, this.in.buffer, this.in.start, this.in.end) == 0) {
                    this.out.value = 0;
                } else {
                    if (this.in.isSet == 1) {
                        this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                        this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                        this.previous.end = length;
                    }
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                if (this.in.isSet == 1) {
                    this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                    this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                    this.previous.end = length;
                }
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueVarChar
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Workspace
        VarCharHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
            this.initialized = false;
            this.previous.buffer = this.buf;
            this.previous.start = 0;
        }

        @Override
        public void eval() {
            int length = this.in.end - this.in.start;
            if (this.initialized.booleanValue()) {
                if (ByteFunctionHelpers.compare(this.previous.buffer, 0, this.previous.end, this.in.buffer, this.in.start, this.in.end) == 0) {
                    this.out.value = 0;
                } else {
                    this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                    this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                    this.previous.end = length;
                    this.out.value = 1;
                }
            } else {
                this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                this.previous.end = length;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueVarCharNullable
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder in;
        @Workspace
        NullableVarCharHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
            this.initialized = false;
            this.previous.buffer = this.buf;
            this.previous.start = 0;
        }

        @Override
        public void eval() {
            int length;
            int n = length = this.in.isSet == 0 ? 0 : this.in.end - this.in.start;
            if (this.initialized.booleanValue()) {
                if (this.previous.isSet == 0 && this.in.isSet == 0) {
                    this.out.value = 0;
                } else if (this.previous.isSet != 0 && this.in.isSet != 0 && ByteFunctionHelpers.compare(this.previous.buffer, 0, this.previous.end, this.in.buffer, this.in.start, this.in.end) == 0) {
                    this.out.value = 0;
                } else {
                    if (this.in.isSet == 1) {
                        this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                        this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                        this.previous.end = length;
                    }
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                if (this.in.isSet == 1) {
                    this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                    this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                    this.previous.end = length;
                }
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueVarBinary
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder in;
        @Workspace
        VarBinaryHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
            this.initialized = false;
            this.previous.buffer = this.buf;
            this.previous.start = 0;
        }

        @Override
        public void eval() {
            int length = this.in.end - this.in.start;
            if (this.initialized.booleanValue()) {
                if (ByteFunctionHelpers.compare(this.previous.buffer, 0, this.previous.end, this.in.buffer, this.in.start, this.in.end) == 0) {
                    this.out.value = 0;
                } else {
                    this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                    this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                    this.previous.end = length;
                    this.out.value = 1;
                }
            } else {
                this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                this.previous.end = length;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueVarBinaryNullable
    implements DrillSimpleFunc {
        @Param
        NullableVarBinaryHolder in;
        @Workspace
        NullableVarBinaryHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;
        @Inject
        DrillBuf buf;

        @Override
        public void setup() {
            this.initialized = false;
            this.previous.buffer = this.buf;
            this.previous.start = 0;
        }

        @Override
        public void eval() {
            int length;
            int n = length = this.in.isSet == 0 ? 0 : this.in.end - this.in.start;
            if (this.initialized.booleanValue()) {
                if (this.previous.isSet == 0 && this.in.isSet == 0) {
                    this.out.value = 0;
                } else if (this.previous.isSet != 0 && this.in.isSet != 0 && ByteFunctionHelpers.compare(this.previous.buffer, 0, this.previous.end, this.in.buffer, this.in.start, this.in.end) == 0) {
                    this.out.value = 0;
                } else {
                    if (this.in.isSet == 1) {
                        this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                        this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                        this.previous.end = length;
                    }
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                if (this.in.isSet == 1) {
                    this.previous.buffer = this.buf = this.buf.reallocIfNeeded(length);
                    this.previous.buffer.setBytes(0, this.in.buffer, this.in.start, length);
                    this.previous.end = length;
                }
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueDecimal18
    implements DrillSimpleFunc {
        @Param
        Decimal18Holder in;
        @Workspace
        Decimal18Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueDecimal18Nullable
    implements DrillSimpleFunc {
        @Param
        NullableDecimal18Holder in;
        @Workspace
        NullableDecimal18Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Workspace
        TimeStampHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueTimeStampNullable
    implements DrillSimpleFunc {
        @Param
        NullableTimeStampHolder in;
        @Workspace
        NullableTimeStampHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Workspace
        DateHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueDateNullable
    implements DrillSimpleFunc {
        @Param
        NullableDateHolder in;
        @Workspace
        NullableDateHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Workspace
        Float8Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueFloat8Nullable
    implements DrillSimpleFunc {
        @Param
        NullableFloat8Holder in;
        @Workspace
        NullableFloat8Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Workspace
        UInt8Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueUInt8Nullable
    implements DrillSimpleFunc {
        @Param
        NullableUInt8Holder in;
        @Workspace
        NullableUInt8Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Workspace
        BigIntHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueBigIntNullable
    implements DrillSimpleFunc {
        @Param
        NullableBigIntHolder in;
        @Workspace
        NullableBigIntHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueDecimal9
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder in;
        @Workspace
        Decimal9Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueDecimal9Nullable
    implements DrillSimpleFunc {
        @Param
        NullableDecimal9Holder in;
        @Workspace
        NullableDecimal9Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder in;
        @Workspace
        TimeHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueTimeNullable
    implements DrillSimpleFunc {
        @Param
        NullableTimeHolder in;
        @Workspace
        NullableTimeHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Workspace
        Float4Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueFloat4Nullable
    implements DrillSimpleFunc {
        @Param
        NullableFloat4Holder in;
        @Workspace
        NullableFloat4Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Workspace
        UInt4Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueUInt4Nullable
    implements DrillSimpleFunc {
        @Param
        NullableUInt4Holder in;
        @Workspace
        NullableUInt4Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Workspace
        IntHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueIntNullable
    implements DrillSimpleFunc {
        @Param
        NullableIntHolder in;
        @Workspace
        NullableIntHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Workspace
        SmallIntHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueSmallIntNullable
    implements DrillSimpleFunc {
        @Param
        NullableSmallIntHolder in;
        @Workspace
        NullableSmallIntHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Workspace
        UInt2Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueUInt2Nullable
    implements DrillSimpleFunc {
        @Param
        NullableUInt2Holder in;
        @Workspace
        NullableUInt2Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Workspace
        UInt1Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueUInt1Nullable
    implements DrillSimpleFunc {
        @Param
        NullableUInt1Holder in;
        @Workspace
        NullableUInt1Holder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Workspace
        TinyIntHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }

    @FunctionTemplate(name="newPartitionValue", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NewValueTinyIntNullable
    implements DrillSimpleFunc {
        @Param
        NullableTinyIntHolder in;
        @Workspace
        NullableTinyIntHolder previous;
        @Workspace
        Boolean initialized;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.initialized = false;
        }

        @Override
        public void eval() {
            if (this.initialized.booleanValue()) {
                if (this.in.isSet == 0 && this.previous.isSet == 0) {
                    this.out.value = 0;
                } else if (this.in.value == this.previous.value) {
                    this.out.value = 0;
                } else {
                    this.previous.value = this.in.value;
                    this.previous.isSet = this.in.isSet;
                    this.out.value = 1;
                }
            } else {
                this.previous.value = this.in.value;
                this.previous.isSet = this.in.isSet;
                this.out.value = 1;
                this.initialized = true;
            }
        }
    }
}

