/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.fn.JodaDateValidator;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@FunctionTemplate(name="convertNullableVarCharSqlToNullableTimeStamp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL, isInternal=true)
public class GNullableVarCharSqlToNullableTimeStamp
implements DrillSimpleFunc {
    @Param
    NullableVarCharHolder left;
    @Param
    VarCharHolder right;
    @Workspace
    DateTimeFormatter format;
    @Output
    NullableTimeStampHolder out;

    @Override
    public void setup() {
        String formatString = StringFunctionHelpers.getStringFromVarCharHolder(this.right);
        String pattern = JodaDateValidator.toJodaFormat(formatString);
        try {
            this.format = DateTimeFormat.forPattern((String)pattern);
        }
        catch (IllegalArgumentException e) {
            throw UserException.functionError(e).message("Error parsing formatter %s in %s function", formatString, "sql_to_nullabletimestamp").build();
        }
    }

    @Override
    public void eval() {
        if (this.left.isSet == 0 || this.left.start == this.left.end) {
            this.out.isSet = 0;
            return;
        }
        this.out.isSet = 1;
        String input = StringFunctionHelpers.getStringFromVarCharHolder(this.left);
        try {
            this.out.value = DateTime.parse((String)input, (DateTimeFormatter)this.format).withZoneRetainFields(DateTimeZone.UTC).getMillis();
        }
        catch (IllegalArgumentException e) {
            throw UserException.functionError(e).message("Error parsing date-time %s in %s function", input, "sql_to_nullabletimestamp").build();
        }
    }
}

