/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import com.google.common.base.Charsets;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@FunctionTemplate(name="convertNullableVarCharToNullableTime", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL, isInternal=true)
public class GNullableVarCharToNullableTime
implements DrillSimpleFunc {
    @Param
    NullableVarCharHolder left;
    @Param
    VarCharHolder right;
    @Workspace
    DateTimeFormatter format;
    @Output
    NullableTimeHolder out;

    @Override
    public void setup() {
        byte[] buf = new byte[this.right.end - this.right.start];
        this.right.buffer.getBytes(this.right.start, buf, 0, this.right.end - this.right.start);
        String formatString = new String(buf, Charsets.UTF_8);
        this.format = DateTimeFormat.forPattern((String)formatString);
    }

    @Override
    public void eval() {
        if (this.left.isSet == 0 || this.left.start == this.left.end) {
            this.out.isSet = 0;
            return;
        }
        this.out.isSet = 1;
        byte[] buf1 = new byte[this.left.end - this.left.start];
        this.left.buffer.getBytes(this.left.start, buf1, 0, this.left.end - this.left.start);
        String input = new String(buf1, Charsets.UTF_8);
        this.out.value = this.format.parseDateTime(input).withZoneRetainFields(DateTimeZone.UTC).getMillisOfDay();
    }
}

