/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import com.google.common.base.Charsets;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.joda.time.DateMidnight;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@FunctionTemplate(name="to_date", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class GVarCharToDate
implements DrillSimpleFunc {
    @Param
    VarCharHolder left;
    @Param
    VarCharHolder right;
    @Workspace
    DateTimeFormatter format;
    @Output
    DateHolder out;

    @Override
    public void setup() {
        byte[] buf = new byte[this.right.end - this.right.start];
        this.right.buffer.getBytes(this.right.start, buf, 0, this.right.end - this.right.start);
        String formatString = new String(buf, Charsets.UTF_8);
        this.format = DateTimeFormat.forPattern((String)formatString);
    }

    @Override
    public void eval() {
        byte[] buf1 = new byte[this.left.end - this.left.start];
        this.left.buffer.getBytes(this.left.start, buf1, 0, this.left.end - this.left.start);
        String input = new String(buf1, Charsets.UTF_8);
        this.out.value = DateMidnight.parse((String)input, (DateTimeFormatter)this.format).withZoneRetainFields(DateTimeZone.UTC).getMillis();
    }
}

