/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.HashHelper;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.Var16CharHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;

public class Hash64Functions {

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class BitHash
    implements DrillSimpleFunc {
        @Param
        BitHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableBitHash
    implements DrillSimpleFunc {
        @Param
        NullableBitHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? 0L : HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableVarDecimalHash
    implements DrillSimpleFunc {
        @Param
        NullableVarDecimalHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? 0L : HashHelper.hash64(this.in.start, this.in.end, this.in.buffer, 0L);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class VarDecimalHash
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.start, this.in.end, this.in.buffer, 0L);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableTimeHash
    implements DrillSimpleFunc {
        @Param
        NullableTimeHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? 0L : HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class TimeHash
    implements DrillSimpleFunc {
        @Param
        TimeHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableTimeStampHash
    implements DrillSimpleFunc {
        @Param
        NullableTimeStampHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? 0L : HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class TimeStampHash
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableDateHash
    implements DrillSimpleFunc {
        @Param
        NullableDateHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? 0L : HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class DateHash
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class IntHash
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class BigIntHash
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class Var16CharHash
    implements DrillSimpleFunc {
        @Param
        Var16CharHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.start, this.in.end, this.in.buffer, 0L);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class VarCharHash
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.start, this.in.end, this.in.buffer, 0L);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class VarBinaryHash
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.start, this.in.end, this.in.buffer, 0L);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableIntHash
    implements DrillSimpleFunc {
        @Param
        NullableIntHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? 0L : HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableBigIntHash
    implements DrillSimpleFunc {
        @Param
        NullableBigIntHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? 0L : HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableVar16CharHash
    implements DrillSimpleFunc {
        @Param
        NullableVar16CharHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? 0L : HashHelper.hash64(this.in.start, this.in.end, this.in.buffer, 0L);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableVarCharHash
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? 0L : HashHelper.hash64(this.in.start, this.in.end, this.in.buffer, 0L);
        }
    }

    @FunctionTemplate(names={"hash64", "hash64AsDouble"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableVarBinaryHash
    implements DrillSimpleFunc {
        @Param
        NullableVarBinaryHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? 0L : HashHelper.hash64(this.in.start, this.in.end, this.in.buffer, 0L);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class DoubleHash
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableDoubleHash
    implements DrillSimpleFunc {
        @Param
        NullableFloat8Holder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? 0L : HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class FloatHash
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, 0L);
        }
    }

    @FunctionTemplate(name="hash64", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableFloatHash
    implements DrillSimpleFunc {
        @Param
        NullableFloat4Holder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? 0L : HashHelper.hash64(this.in.value, 0L);
        }
    }
}

