/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import java.math.BigDecimal;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.HashHelper;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.util.DecimalUtility;

public class Hash64WithSeedAsDouble {

    @FunctionTemplate(name="hash64AsDouble", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableVarDecimalHash
    implements DrillSimpleFunc {
        @Param
        NullableVarDecimalHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (this.in.isSet == 0) {
                this.out.value = this.seed.value;
            } else {
                BigDecimal input = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale);
                this.out.value = HashHelper.hash64(input.doubleValue(), this.seed.value);
            }
        }
    }

    @FunctionTemplate(name="hash64AsDouble", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class VarDecimalHash
    implements DrillSimpleFunc {
        @Param
        VarDecimalHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal input = DecimalUtility.getBigDecimalFromDrillBuf(this.in.buffer, this.in.start, this.in.end - this.in.start, this.in.scale);
            this.out.value = HashHelper.hash64(input.doubleValue(), this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64AsDouble", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class IntHash
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64((double)this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64AsDouble", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class BigIntHash
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64((double)this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64AsDouble", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableIntHash
    implements DrillSimpleFunc {
        @Param
        NullableIntHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64((double)this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64AsDouble", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableBigIntHash
    implements DrillSimpleFunc {
        @Param
        NullableBigIntHolder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64((double)this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64AsDouble", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class DoubleHash
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64AsDouble", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableDoubleHash
    implements DrillSimpleFunc {
        @Param
        NullableFloat8Holder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64(this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64AsDouble", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class FloatHash
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = HashHelper.hash64((double)this.in.value, this.seed.value);
        }
    }

    @FunctionTemplate(name="hash64AsDouble", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class NullableFloatHash
    implements DrillSimpleFunc {
        @Param
        NullableFloat4Holder in;
        @Param
        BigIntHolder seed;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? this.seed.value : HashHelper.hash64((double)this.in.value, this.seed.value);
        }
    }
}

