/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.drill.exec.expr.fn.impl.MurmurHash3;

public class HashHelper {
    public static int hash(ByteBuffer buf, int seed) {
        int m = 1540483477;
        int r = 24;
        int h = seed ^ buf.remaining();
        while (buf.remaining() >= 4) {
            int k = buf.getInt();
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
        }
        if (buf.remaining() > 0) {
            ByteBuffer finish = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            finish.put(buf).rewind();
            h ^= finish.getInt();
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    public static int hash32(int val, long seed) {
        double converted = val;
        return HashHelper.hash32(converted, seed);
    }

    public static int hash32(long val, long seed) {
        double converted = val;
        return HashHelper.hash32(converted, seed);
    }

    public static int hash32(float val, long seed) {
        double converted = val;
        return HashHelper.hash32(converted, seed);
    }

    public static long hash64(float val, long seed) {
        double converted = val;
        return HashHelper.hash64(converted, seed);
    }

    public static long hash64(long val, long seed) {
        double converted = val;
        return HashHelper.hash64(converted, seed);
    }

    public static long hash64(double val, long seed) {
        return MurmurHash3.hash64(val, (int)seed);
    }

    public static long hash64(long start, long end, DrillBuf buffer, long seed) {
        return MurmurHash3.hash64(start, end, buffer, (int)seed);
    }

    public static int hash32(double val, long seed) {
        return MurmurHash3.hash32(val, (int)seed);
    }

    public static int hash32(int start, int end, DrillBuf buffer, int seed) {
        return MurmurHash3.hash32(start, end, buffer, seed);
    }
}

