/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;

public class IntervalDayIntFunctions {

    @FunctionTemplate(names={"divide", "div", "/int"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalDayIntDivideFunction
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        IntHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            double fractionalMonths = 0.0;
            double fractionalDays = 0.0;
            double fractionalMillis = 0.0;
            fractionalDays = this.left.days / this.right.value;
            fractionalMillis = (double)this.left.milliseconds / (double)this.right.value;
            this.out.months = (int)fractionalMonths;
            fractionalMonths -= (double)((long)fractionalMonths);
            this.out.days = (int)(fractionalDays += fractionalMonths * 30.0);
            fractionalDays -= (double)((long)fractionalDays);
            this.out.milliseconds = (int)(fractionalMillis += fractionalDays * 8.64E7);
        }
    }

    @FunctionTemplate(name="multiply", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntIntervalDayMultiplyFunction
    implements DrillSimpleFunc {
        @Param
        IntHolder right;
        @Param
        IntervalDayHolder left;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.days = this.left.days * this.right.value;
            this.out.milliseconds = this.left.milliseconds * this.right.value;
        }
    }

    @FunctionTemplate(name="multiply", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalDayIntMultiplyFunction
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        IntHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.days = this.left.days * this.right.value;
            this.out.milliseconds = this.left.milliseconds * this.right.value;
        }
    }
}

