/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.IntervalHolder;

public class IntervalFunctions {

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalNegateFunction
    implements DrillSimpleFunc {
        @Param
        IntervalHolder left;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.months = -this.left.months;
            this.out.days = -this.left.days;
            this.out.milliseconds = -this.left.milliseconds;
        }
    }

    @FunctionTemplate(name="subtract", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalSubtractFunction
    implements DrillSimpleFunc {
        @Param
        IntervalHolder left;
        @Param
        IntervalHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.months = this.left.months - this.right.months;
            this.out.days = this.left.days - this.right.days;
            this.out.milliseconds = this.left.milliseconds - this.right.milliseconds;
        }
    }

    @FunctionTemplate(name="add", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalAddFunction
    implements DrillSimpleFunc {
        @Param
        IntervalHolder left;
        @Param
        IntervalHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.months = this.left.months + this.right.months;
            this.out.days = this.left.days + this.right.days;
            this.out.milliseconds = this.left.milliseconds + this.right.milliseconds;
        }
    }
}

