/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.IsEmptyUtils;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public class IsEmptyScalarFunctions {
    private IsEmptyScalarFunctions() {
    }

    @FunctionTemplate(names={"isempty", "is_empty"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class IsEmptyMapFunctions
    implements DrillSimpleFunc {
        @Param
        FieldReader input;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = IsEmptyUtils.mapIsEmpty(this.input) ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"isempty", "is_empty"}, scope=FunctionTemplate.FunctionScope.SIMPLE)
    public static class IsEmptyVarcharFunctions
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder input;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            String data;
            this.out.value = this.input.start == 0 && this.input.end == 0 ? 1 : (StringUtils.isEmpty((CharSequence)(data = StringFunctionHelpers.toStringFromUTF8(this.input.start, this.input.end, this.input.buffer))) ? 1 : 0);
        }
    }
}

